/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.bi.BiContext;
import org.symphonyoss.symphony.messageml.elements.MessageML;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.exceptions.ProcessingException;
import org.symphonyoss.symphony.messageml.markdown.MarkdownParser;
import org.symphonyoss.symphony.messageml.markdown.MarkdownRenderer;
import org.symphonyoss.symphony.messageml.util.IDataProvider;
import org.symphonyoss.symphony.messageml.util.ShortID;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MessageMLContext {
    private final MessageMLParser messageMLParser;
    private final MarkdownParser markdownParser;
    private final ShortID shortID;
    private MarkdownRenderer markdownRenderer;
    private MessageML messageML;
    private ObjectNode entityJson;
    private BiContext biContext;
    private String presentationML;

    public MessageMLContext(IDataProvider dataProvider) {
        this.markdownParser = new MarkdownParser(dataProvider);
        this.messageMLParser = new MessageMLParser(dataProvider);
        this.shortID = new ShortID();
        this.biContext = new BiContext();
    }

    public void parseMessageML(String message, String entityJson, String version) throws InvalidInputException, IOException, ProcessingException {
        this.presentationML = null;
        this.messageML = this.messageMLParser.parse(message, entityJson, version);
        this.entityJson = this.messageMLParser.getEntityJson();
        this.biContext = this.messageMLParser.getBiContext();
        this.markdownRenderer = new MarkdownRenderer(this.messageML.asMarkdown());
    }

    public void parseMarkdown(String message, JsonNode entities, JsonNode media) throws InvalidInputException {
        this.presentationML = null;
        this.messageML = this.markdownParser.parse(message, entities, media);
        this.entityJson = this.messageML.asEntityJson(this.entityJson);
        this.biContext = new BiContext();
        this.markdownRenderer = new MarkdownRenderer(this.messageML.asMarkdown());
    }

    public MessageML getMessageML() throws IllegalStateException {
        if (this.messageML == null) {
            return this.throwCallParseFirstException();
        }
        return this.messageML;
    }

    public String getPresentationML() throws IllegalStateException {
        if (this.presentationML != null) {
            return this.presentationML;
        }
        if (this.messageML == null) {
            this.throwCallParseFirstException();
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        XmlPrintStream out = new XmlPrintStream(bout);
        out.setNoIndent(true);
        out.setNoNl(true);
        this.messageML.asPresentationML(out, this);
        out.close();
        this.presentationML = bout.toString();
        return this.presentationML;
    }

    public ObjectNode getEntityJson() {
        if (this.messageML == null) {
            this.throwCallParseFirstException();
        }
        return this.entityJson;
    }

    public String getMarkdown() throws IllegalStateException {
        if (this.messageML == null) {
            this.throwCallParseFirstException();
        }
        return this.markdownRenderer.getText();
    }

    public JsonNode getEntities() throws IllegalStateException {
        if (this.messageML == null) {
            this.throwCallParseFirstException();
        }
        return this.markdownRenderer.getJson();
    }

    public String getText() throws InvalidInputException, ProcessingException, IllegalStateException {
        if (this.messageML == null) {
            this.throwCallParseFirstException();
        }
        Element doc = this.messageMLParser.parseDocument(this.getPresentationML());
        return doc.getTextContent();
    }

    public String getText(boolean preserveWhitespace) throws InvalidInputException, ProcessingException, IllegalStateException {
        if (this.messageML == null) {
            this.throwCallParseFirstException();
        }
        StringBuilder sb = new StringBuilder();
        Element doc = this.messageMLParser.parseDocument(this.getPresentationML());
        NodeList nodes = doc.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            String text;
            Node node = nodes.item(i);
            String string = text = preserveWhitespace ? node.getTextContent() : node.getTextContent().trim();
            if (i > 0 && StringUtils.isNotEmpty((CharSequence)text)) {
                sb.append(" ");
            }
            sb.append(text);
        }
        return sb.toString();
    }

    public String generateShortId() {
        return this.shortID.generate();
    }

    public BiContext getBiContext() {
        return this.biContext;
    }

    private MessageML throwCallParseFirstException() {
        throw new IllegalStateException("The message hasn't been parsed yet. Please call MessageMLContext.parse() first.");
    }
}

