/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.jcurl;

import com.shaded.fasterxml.jackson.databind.JsonNode;
import com.shaded.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.symphonyoss.symphony.jcurl.MultipartUtility;

public class JCurl {
    private String url;
    private String data;
    private String keyStore;
    private String storeType;
    private String storePass;
    private String trustStore;
    private String trustType;
    private String trustPass;
    private String proxyHost;
    private String proxyPort;
    private String nonProxyHosts;
    private int verbosity;
    private int connectTimeout;
    private int readTimeout;
    private boolean trustAllHostnames;
    private boolean trustAllCerts;
    private boolean extractCookies;
    private List<String> tagList = new ArrayList<String>();
    private Map<String, String> tagMap = new HashMap<String, String>();
    private Map<String, String> formMap = new HashMap<String, String>();
    private Map<String, String> headerMap = new HashMap<String, String>();
    private Map<String, String> queryMap = new HashMap<String, String>();
    private Map<String, String> cookieMap = new HashMap<String, String>();
    private Set<Integer> expectedResponseSet = new HashSet<Integer>();
    private HttpMethod method = HttpMethod.GET;
    private String contentType = "application/json";
    static final ObjectMapper MAPPER = new ObjectMapper();
    static final HostnameVerifier DEFAULT_HOSTNAME_VERIFIER = HttpsURLConnection.getDefaultHostnameVerifier();

    public static void main(String[] argv) throws IOException, CertificateParsingException, KeyManagementException, NoSuchAlgorithmException {
        ConfigParser config = new ConfigParser();
        JCurl jcurl = config.parseCommandLine(argv);
        HttpURLConnection con = jcurl.connect(config.url);
        Response response = jcurl.processResponse(con);
        response.print();
    }

    public static Builder builder() {
        return new Builder();
    }

    public HttpURLConnection connect() throws IOException {
        if (this.url == null || "".equals(this.url.trim())) {
            System.err.println("A URL is required");
            System.err.println("Try 'jcurl -h' or 'jcurl -help' for more information.");
            System.exit(1);
        }
        return this.connect(this.url);
    }

    public HttpURLConnection connect(URL url) throws IOException {
        return this.connect(url.toString());
    }

    public HttpURLConnection connect(String urlString) throws IOException {
        this.url = urlString;
        String targetUrl = this.buildUrl();
        URLConnection rawCon = new URL(targetUrl).openConnection();
        if (!(rawCon instanceof HttpURLConnection)) {
            System.err.println("Only http(s) is supported. Connection is of type " + rawCon.getClass());
            System.exit(1);
        }
        HttpURLConnection con = (HttpURLConnection)rawCon;
        con.setConnectTimeout(this.connectTimeout);
        con.setReadTimeout(this.readTimeout);
        con.setRequestProperty("User-Agent", "JCurl");
        con.setRequestProperty("Content-Type", this.contentType);
        for (Map.Entry<String, String> entry : this.headerMap.entrySet()) {
            con.setRequestProperty(entry.getKey(), entry.getValue());
        }
        if (!this.cookieMap.isEmpty()) {
            StringBuilder cookieBuilder = new StringBuilder();
            Iterator<Map.Entry<String, String>> iterator = this.cookieMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> cookie = iterator.next();
                cookieBuilder.append(cookie.getKey()).append("=").append(cookie.getValue());
                if (!iterator.hasNext()) continue;
                cookieBuilder.append("; ");
            }
            con.setRequestProperty("Cookie", cookieBuilder.toString());
        }
        if (this.verbosity >= 1) {
            System.err.println(this.toString());
            for (Map.Entry entry : con.getRequestProperties().entrySet()) {
                for (String v : (List)entry.getValue()) {
                    if (entry.getKey() == null) {
                        System.err.println("> " + v);
                        continue;
                    }
                    System.err.println("> " + (String)entry.getKey() + ": " + v);
                }
            }
            System.err.println(">");
        }
        switch (this.method) {
            case POST: {
                con.setRequestMethod("POST");
                if (this.data != null) {
                    con.setDoOutput(true);
                    DataOutputStream wr = new DataOutputStream(con.getOutputStream());
                    wr.writeBytes(this.data);
                    if (this.verbosity >= 1) {
                        System.err.print("> ");
                        System.err.println(this.data);
                    }
                    wr.flush();
                    wr.close();
                }
                if (this.formMap.isEmpty()) break;
                MultipartUtility multipart = new MultipartUtility(con);
                for (Map.Entry<String, String> field : this.formMap.entrySet()) {
                    String key = field.getKey();
                    String value = field.getValue();
                    if (value.startsWith("@")) {
                        multipart.addFilePart(key, new File(value.substring(1)));
                        continue;
                    }
                    multipart.addFormField(key, value);
                }
                multipart.finish();
                break;
            }
            default: {
                con.setRequestMethod(this.method.name());
            }
        }
        return con;
    }

    public Response processResponse(HttpURLConnection con) throws IOException, CertificateParsingException {
        Response response = new Response();
        long startTime = System.nanoTime();
        con.connect();
        long endTime = System.nanoTime();
        response.timeTaken = endTime - startTime;
        this.processResponseHeaders(con, response);
        this.processResponseCode(con, response);
        this.processResponseCertificates(con, response);
        this.processResponseOutput(con, response);
        this.processResponseTags(response);
        return response;
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        output.append("java -jar jcurl.jar ");
        if (this.keyStore != null) {
            output.append(String.format("-keystore %s ", this.keyStore));
        }
        if (this.storePass != null) {
            output.append(String.format("-storepass %s ", this.storePass));
        }
        if (this.storeType != null) {
            output.append(String.format("-storetype %s ", this.storeType));
        }
        if (this.trustStore != null) {
            output.append(String.format("-truststore %s ", this.trustStore));
        }
        if (this.trustPass != null) {
            output.append(String.format("-trustpass %s ", this.trustPass));
        }
        if (this.trustType != null) {
            output.append(String.format("-trusttype %s ", this.trustType));
        }
        for (Map.Entry<String, String> entry : this.headerMap.entrySet()) {
            output.append(String.format("-H %s %s ", entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<String, String> entry : this.cookieMap.entrySet()) {
            output.append(String.format("-b %s %s ", entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<String, String> entry : this.formMap.entrySet()) {
            output.append(String.format("-F %s %s ", entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<String, String> entry : this.tagMap.entrySet()) {
            output.append(String.format("-t %s %s ", entry.getKey(), entry.getValue()));
        }
        for (String string : this.tagList) {
            output.append(String.format("-a %s ", string));
        }
        if (this.extractCookies) {
            output.append("-c ");
        }
        for (Integer n : this.expectedResponseSet) {
            if (n == 200) continue;
            output.append(String.format("-http %s ", n));
        }
        if (this.proxyHost != null) {
            output.append(String.format("-x %s:%s ", this.proxyHost, this.proxyPort));
        }
        if (this.nonProxyHosts != null) {
            output.append(String.format("-noproxy %s ", this.nonProxyHosts));
        }
        if (this.trustAllHostnames) {
            output.append("-no-verify-hostname ");
        }
        if (this.trustAllCerts) {
            output.append("-no-check-certificate ");
        }
        if (this.verbosity > 0) {
            output.append(String.format("-%0" + this.verbosity + "d ", 0).replace("0", "v"));
        }
        if (this.data != null) {
            output.append(String.format("-data %s ", this.data));
        } else if (this.method == HttpMethod.POST) {
            output.append("-post ");
        } else {
            output.append(String.format("-X %s ", this.method.name()));
        }
        output.append(this.buildUrl());
        return output.toString();
    }

    private void processResponseHeaders(HttpURLConnection con, Response response) throws IOException {
        for (Map.Entry<String, List<String>> header : con.getHeaderFields().entrySet()) {
            String headerName = header.getKey();
            List<String> headerValue = header.getValue();
            if (headerName == null || headerValue == null) continue;
            if ("Content-Type".equalsIgnoreCase(headerName)) {
                String contentType = headerValue.get(0);
                if (contentType == null) continue;
                response.responseContentType = contentType.split(";")[0];
                continue;
            }
            if ("Set-Cookie".equalsIgnoreCase(headerName)) {
                for (String cookie : headerValue) {
                    String[] cookieKV;
                    String[] cookieValues = cookie.split(";\\s*");
                    if (cookieValues.length <= 0 || (cookieKV = cookieValues[0].split("=")).length != 2) continue;
                    response.cookies.put(cookieKV[0], cookieKV[1]);
                }
                continue;
            }
            response.headers.put(headerName, headerValue);
        }
    }

    private void processResponseCode(HttpURLConnection con, Response response) throws IOException {
        try {
            response.responseCode = con.getResponseCode();
        }
        catch (FileNotFoundException e) {
            response.responseCode = 404;
        }
    }

    private void processResponseCertificates(HttpURLConnection con, Response response) throws SSLPeerUnverifiedException {
        if (con instanceof HttpsURLConnection) {
            try {
                HttpsURLConnection secureConn = (HttpsURLConnection)con;
                response.cipherSuite = secureConn.getCipherSuite();
                Response.access$3602(response, secureConn.getServerCertificates());
                Response.access$3702(response, secureConn.getLocalCertificates());
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResponseOutput(HttpURLConnection con, Response response) throws IOException {
        try (InputStream in = con.getErrorStream();){
            int length;
            if (in == null) {
                in = con.getInputStream();
            }
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = in.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            response.output = result.toString();
        }
    }

    private void processResponseTags(Response response) {
        if (response.output != null && !"".equals(response.output.trim()) && "application/json".equalsIgnoreCase(this.contentType) && "application/json".equalsIgnoreCase(response.responseContentType)) {
            String part;
            int n;
            int n2;
            String[] stringArray;
            JsonNode value;
            JsonNode responseJson;
            try {
                responseJson = response.getJsonNode();
            }
            catch (IOException e) {
                return;
            }
            if (responseJson == null) {
                return;
            }
            for (Map.Entry<String, String> entry : this.tagMap.entrySet()) {
                String name = entry.getKey();
                String tag = entry.getValue();
                value = responseJson;
                stringArray = tag.split("\\.");
                n2 = stringArray.length;
                for (n = 0; n < n2 && (value = value.get(part = stringArray[n])) != null; ++n) {
                }
                response.tagMap.put(name, value != null ? value.asText() : null);
            }
            for (JsonNode childNode : responseJson) {
                for (String tag : this.tagList) {
                    value = childNode;
                    stringArray = tag.split("\\.");
                    n2 = stringArray.length;
                    for (n = 0; n < n2 && (value = value.get(part = stringArray[n])) != null; ++n) {
                    }
                    if (value == null) continue;
                    response.tagList.add(value.asText());
                }
            }
        }
    }

    private String buildUrl() {
        if (this.queryMap == null || this.queryMap.isEmpty()) {
            return this.url;
        }
        StringBuilder urlBuilder = new StringBuilder(this.url);
        String[] urlParts = this.url.split("/");
        if (urlParts[urlParts.length - 1].contains("?")) {
            urlBuilder.append("&");
        } else {
            urlBuilder.append("?");
        }
        Iterator<Map.Entry<String, String>> it = this.queryMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> queryParam = it.next();
            urlBuilder.append(String.format("%s=%s", queryParam.getKey(), queryParam.getValue()));
            if (!it.hasNext()) continue;
            urlBuilder.append("&");
        }
        return urlBuilder.toString();
    }

    public String getUrl() {
        return this.url;
    }

    public String getData() {
        return this.data;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public String getStoreType() {
        return this.storeType;
    }

    public String getStorePass() {
        return this.storePass;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public String getTrustType() {
        return this.trustType;
    }

    public String getTrustPass() {
        return this.trustPass;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public int getVerbosity() {
        return this.verbosity;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public boolean isTrustAllHostnames() {
        return this.trustAllHostnames;
    }

    public boolean isTrustAllCerts() {
        return this.trustAllCerts;
    }

    public boolean isExtractCookies() {
        return this.extractCookies;
    }

    public List<String> getTagList() {
        return this.tagList;
    }

    public Map<String, String> getTagMap() {
        return this.tagMap;
    }

    public Map<String, String> getFormMap() {
        return this.formMap;
    }

    public Map<String, String> getHeaderMap() {
        return this.headerMap;
    }

    public Map<String, String> getQueryMap() {
        return this.queryMap;
    }

    public Map<String, String> getCookieMap() {
        return this.cookieMap;
    }

    public Set<Integer> getExpectedResponseSet() {
        return this.expectedResponseSet;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getContentType() {
        return this.contentType;
    }

    static class AllTrustingTrustManager
    implements X509TrustManager {
        AllTrustingTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String type) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String type) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    static class AllValidatingHostnameVerifier
    implements HostnameVerifier {
        AllValidatingHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession sslSession) {
            return true;
        }
    }

    public class Response {
        private int responseCode;
        private long timeTaken;
        private String cipherSuite;
        private String output;
        private String responseContentType;
        private Certificate[] serverCertificates;
        private Certificate[] clientCertificates;
        private Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        private Map<String, String> cookies = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        private Map<String, String> tagMap = new HashMap<String, String>();
        private List<String> tagList = new ArrayList<String>();
        private JsonNode jsonNode;

        public void print() throws CertificateParsingException, IOException {
            if (JCurl.this.verbosity >= 2) {
                this.printCertificateDetails();
            }
            if (JCurl.this.verbosity >= 1) {
                System.err.println("* Time taken: " + this.timeTaken / 1000000L + " ms");
                this.printResponseDetails();
                System.err.println("<");
            }
            if (JCurl.this.verbosity >= 1 || this.output != null) {
                this.printOutput();
            }
            if (!JCurl.this.expectedResponseSet.contains(this.responseCode)) {
                System.out.println("httpStatus=" + this.responseCode);
                System.exit(1);
            }
            if (this.output != null) {
                if ("application/json".equalsIgnoreCase(JCurl.this.contentType) && "application/json".equalsIgnoreCase(this.responseContentType)) {
                    this.printResponseJson();
                } else {
                    System.err.println(this.output);
                }
            }
        }

        private void printCertificateDetails() throws CertificateParsingException {
            try {
                System.err.println("* Cipher Suite       : " + this.cipherSuite);
                for (Certificate cert : this.serverCertificates) {
                    System.err.println("* Cert Type          : " + cert.getType());
                    if (cert instanceof X509Certificate) {
                        X509Certificate x509Cert = (X509Certificate)cert;
                        System.err.println("*      Issuer        : " + x509Cert.getIssuerDN());
                        System.err.println("*      Subject       : " + x509Cert.getSubjectDN());
                        System.err.println("*      Issuer ID     : " + x509Cert.getIssuerUniqueID());
                        System.err.println("*      Sig Algorithm : " + x509Cert.getSigAlgName());
                        System.err.println("*      Basic Const   : " + x509Cert.getBasicConstraints());
                        System.err.println("*      Ext Key Usage : " + x509Cert.getExtendedKeyUsage());
                        System.err.println("*      Not Before    : " + x509Cert.getNotBefore());
                        System.err.println("*      Not After     : " + x509Cert.getNotAfter());
                        System.err.println("*      Subject ID    : " + x509Cert.getSubjectUniqueID());
                        Collection<List<?>> altNames = x509Cert.getSubjectAlternativeNames();
                        if (altNames != null) {
                            for (List<?> nameList : altNames) {
                                for (Object name : nameList) {
                                    System.err.println("*      Alt Name     : " + name);
                                }
                            }
                        }
                    }
                    System.err.println("*      Hash Code     : " + cert.hashCode());
                    System.err.println("*      PubKey Algo   : " + cert.getPublicKey().getAlgorithm());
                    System.err.println("*      PubKey Format : " + cert.getPublicKey().getFormat());
                    System.err.println("\n");
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        private void printResponseDetails() throws CertificateParsingException {
            System.err.println("* HTTP Response: " + this.responseCode);
            for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
                for (String v : entry.getValue()) {
                    if (entry.getKey() == null) {
                        System.err.println("< " + v);
                        continue;
                    }
                    System.err.println("< " + entry.getKey() + " : " + v);
                }
            }
        }

        private void printOutput() throws IOException {
            boolean newline = true;
            try (StringReader reader = new StringReader(this.output);){
                int c;
                block11: while ((c = reader.read()) != -1) {
                    if (JCurl.this.verbosity < 1) continue;
                    if (newline) {
                        System.err.print("< ");
                        newline = false;
                    }
                    switch (c) {
                        case 10: {
                            newline = true;
                            System.err.println();
                            continue block11;
                        }
                        case 13: {
                            System.err.print("\\r");
                            continue block11;
                        }
                        case 9: {
                            System.err.print("\\t");
                            continue block11;
                        }
                        case 8: {
                            System.err.print("\\b");
                            continue block11;
                        }
                    }
                    System.err.write(c);
                }
                System.err.println();
                System.err.flush();
            }
        }

        private void printResponseJson() throws IOException {
            JsonNode jsonNode = this.getJsonNode();
            if (!this.tagMap.isEmpty()) {
                this.printTagMap();
            }
            if (!this.tagList.isEmpty()) {
                this.printTagList();
            }
            if (this.tagList.isEmpty() && this.tagMap.isEmpty()) {
                System.out.println(jsonNode.toString());
            }
            if (JCurl.this.extractCookies) {
                this.printCookies();
            }
        }

        private void printTagMap() {
            for (Map.Entry<String, String> entry : this.tagMap.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                System.out.print(" " + name + "=\"");
                if (value == null) {
                    System.out.print("null");
                } else {
                    System.out.print(value.replaceAll("\"", "\\\\\""));
                }
                System.out.println("\"");
            }
            System.out.println();
        }

        private void printTagList() {
            for (String tag : this.tagList) {
                System.out.print(tag + " ");
            }
        }

        private void printCookies() throws IOException {
            for (Map.Entry<String, String> cookie : this.cookies.entrySet()) {
                System.out.println(cookie.getKey() + "=" + cookie.getValue());
            }
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public long getTimeTaken() {
            return this.timeTaken;
        }

        public String getCipherSuite() {
            return this.cipherSuite;
        }

        public Certificate[] getServerCertificates() {
            return this.serverCertificates;
        }

        public Certificate[] getClientCertificates() {
            return this.clientCertificates;
        }

        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        public List<String> getHeader(String name) {
            return this.headers.get(name);
        }

        public Map<String, String> getCookies() {
            return this.cookies;
        }

        public String getCookie(String name) {
            return this.cookies.get(name);
        }

        public String getOutput() {
            return this.output;
        }

        public String getTag(String key) {
            return this.tagMap.get(key);
        }

        public Map<String, String> getTagMap() {
            return new HashMap<String, String>(this.tagMap);
        }

        public List<String> getTagList() {
            return new ArrayList<String>(this.tagList);
        }

        public String getTag(int index) {
            return this.tagList.get(index);
        }

        public String getContentType() {
            return this.responseContentType;
        }

        public JsonNode getJsonNode() throws IOException {
            if (this.jsonNode == null) {
                this.jsonNode = MAPPER.readTree(this.output);
            }
            return this.jsonNode;
        }

        static /* synthetic */ Certificate[] access$3602(Response x0, Certificate[] x1) {
            x0.serverCertificates = x1;
            return x1;
        }

        static /* synthetic */ Certificate[] access$3702(Response x0, Certificate[] x1) {
            x0.clientCertificates = x1;
            return x1;
        }
    }

    private static class ConfigParser {
        private String[] argv;
        private int argi = 0;
        private String url;

        private ConfigParser() {
        }

        private JCurl parseCommandLine(String[] args) throws MalformedURLException, NoSuchAlgorithmException, KeyManagementException {
            this.argv = args;
            Builder builder = JCurl.builder();
            if (this.argv.length == 0) {
                this.printUsage();
                System.exit(0);
            }
            String urlString = null;
            while (this.argi < this.argv.length) {
                switch (this.argv[this.argi]) {
                    case "-K": 
                    case "-config": {
                        String config = this.getNextArg();
                        return this.parseConfig(config);
                    }
                    case "-d": 
                    case "-data": {
                        String payload = this.getNextArg();
                        builder.data(payload);
                        break;
                    }
                    case "-t": {
                        String tagMapLabel = this.getNextArg();
                        String tagMapNode = this.getNextArg();
                        builder.extract(tagMapLabel, tagMapNode);
                        break;
                    }
                    case "-a": {
                        String tagListNode = this.getNextArg();
                        builder.extract(tagListNode);
                        break;
                    }
                    case "-c": 
                    case "-extract-cookies": {
                        builder.extractCookies(true);
                        break;
                    }
                    case "-H": 
                    case "-header": {
                        String headerName = this.getNextArg();
                        String headerValue = this.getNextArg();
                        builder.header(headerName, headerValue);
                        break;
                    }
                    case "-b": 
                    case "-cookie": {
                        String cookieName = this.getNextArg();
                        String cookieValue = this.getNextArg();
                        builder.cookie(cookieName, cookieValue);
                        break;
                    }
                    case "-F": 
                    case "-form": {
                        String formName = this.getNextArg();
                        String formValue = this.getNextArg();
                        builder.form(formName, formValue);
                        break;
                    }
                    case "-q": 
                    case "-query": {
                        String paramName = this.getNextArg();
                        String paramValue = this.getNextArg();
                        builder.query(paramName, paramValue);
                        break;
                    }
                    case "-X": 
                    case "-request": {
                        String method = this.getNextArg().toUpperCase();
                        builder.method(HttpMethod.valueOf(method));
                        break;
                    }
                    case "-post": {
                        builder.method(HttpMethod.POST);
                        break;
                    }
                    case "-v": {
                        builder.verbosity(1);
                        break;
                    }
                    case "-vv": {
                        builder.verbosity(2);
                        break;
                    }
                    case "-vvv": {
                        builder.verbosity(3);
                        break;
                    }
                    case "-http": {
                        int expectedStatus = this.getNextIntArg();
                        builder.expect(expectedStatus);
                        break;
                    }
                    case "-x": 
                    case "-proxy": {
                        String proxyUrl = this.getNextArg();
                        builder.proxy(proxyUrl);
                        break;
                    }
                    case "-noproxy": {
                        String nonProxyHosts = this.getNextArg();
                        builder.nonProxyHosts(nonProxyHosts);
                        break;
                    }
                    case "-keystore": {
                        String keyStore = this.getNextArg();
                        builder.keystore(keyStore);
                        break;
                    }
                    case "-storepass": {
                        String storePass = this.getNextArg();
                        builder.storepass(storePass);
                        break;
                    }
                    case "-storetype": {
                        String storeType = this.getNextArg();
                        builder.storetype(storeType);
                        break;
                    }
                    case "-truststore": {
                        String trustStore = this.getNextArg();
                        builder.truststore(trustStore);
                        break;
                    }
                    case "-trustpass": {
                        String trustPass = this.getNextArg();
                        builder.trustpass(trustPass);
                        break;
                    }
                    case "-trusttype": {
                        String trustType = this.getNextArg();
                        builder.trusttype(trustType);
                        break;
                    }
                    case "-k": 
                    case "-insecure": {
                        builder.insecure(true);
                        break;
                    }
                    case "-no-verify-hostname": {
                        builder.trustAllHostnames(true);
                        break;
                    }
                    case "-no-check-certificate": {
                        builder.trustAllCertificates(true);
                        break;
                    }
                    case "-h": 
                    case "-help": {
                        String help = this.getOptionalArg();
                        if (help == null) {
                            this.printUsage();
                        } else {
                            this.printConfigSample();
                        }
                        System.exit(0);
                    }
                    default: {
                        if (urlString == null) {
                            urlString = this.argv[this.argi];
                            break;
                        }
                        System.err.println("Invalid additional parameter \"" + this.argv[this.argi] + "\"");
                        System.err.println("Try 'jcurl -h' or 'jcurl -help' for more information.");
                        System.exit(1);
                    }
                }
                ++this.argi;
            }
            if (urlString == null || urlString.equals("")) {
                System.err.println("A URL is required");
                System.err.println("Try 'jcurl -h' or 'jcurl -help' for more information.");
                System.exit(1);
            }
            this.url = urlString;
            return builder.build();
        }

        private String getOptionalArg() {
            if (this.argi < this.argv.length - 1) {
                return this.argv[++this.argi];
            }
            return null;
        }

        private String getNextArg() {
            if (this.argi >= this.argv.length - 1) {
                System.err.println(this.argv[this.argi] + " requires a parameter.");
                System.exit(1);
            }
            return this.argv[++this.argi];
        }

        private int getNextIntArg() {
            if (this.argi >= this.argv.length - 1) {
                System.err.println(this.argv[this.argi] + " requires a parameter.");
                System.exit(1);
            }
            String s = this.argv[++this.argi];
            int i = 0;
            try {
                i = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                System.err.println(this.argv[this.argi] + " requires an integer parameter.");
                System.exit(1);
            }
            return i;
        }

        private JCurl parseConfig(String config) {
            JCurl jCurl;
            FileInputStream input = new FileInputStream(config);
            try {
                Builder builder = JCurl.builder();
                JsonNode properties = MAPPER.readTree(input);
                Iterator<Map.Entry<String, JsonNode>> it = properties.fields();
                block53: while (it.hasNext()) {
                    Map.Entry<String, JsonNode> field = it.next();
                    String key = field.getKey();
                    JsonNode value = field.getValue();
                    switch (key) {
                        case "keystore": {
                            builder.keystore(value.asText());
                            break;
                        }
                        case "storepass": {
                            builder.storepass(value.asText());
                            break;
                        }
                        case "storetype": {
                            builder.storetype(value.asText());
                            break;
                        }
                        case "truststore": {
                            builder.truststore(value.asText());
                            break;
                        }
                        case "trustpass": {
                            builder.trustpass(value.asText());
                            break;
                        }
                        case "trusttype": {
                            builder.trusttype(value.asText());
                            break;
                        }
                        case "insecure": {
                            builder.insecure(value.asBoolean());
                            break;
                        }
                        case "no-verify-hostname": {
                            builder.trustAllHostnames(value.asBoolean());
                            break;
                        }
                        case "no-check-certificate": {
                            builder.trustAllCertificates(value.asBoolean());
                            break;
                        }
                        case "proxy": {
                            builder.proxy(value.asText());
                            break;
                        }
                        case "noproxy": {
                            builder.nonProxyHosts(value.asText());
                            break;
                        }
                        case "connect-timeout": {
                            builder.connectTimeout(value.asInt());
                            break;
                        }
                        case "read-timeout": {
                            builder.readTimeout(value.asInt());
                            break;
                        }
                        case "verbosity": {
                            builder.verbosity(value.asInt());
                            break;
                        }
                        case "extract": {
                            Iterator<Map.Entry<String, JsonNode>> eit = value.fields();
                            while (eit.hasNext()) {
                                Map.Entry<String, JsonNode> extract = eit.next();
                                builder.extract(extract.getKey(), extract.getValue().asText());
                            }
                            continue block53;
                        }
                        case "headers": {
                            Iterator<Map.Entry<String, JsonNode>> hit = value.fields();
                            while (hit.hasNext()) {
                                Map.Entry<String, JsonNode> header = hit.next();
                                builder.header(header.getKey(), header.getValue().asText());
                            }
                            continue block53;
                        }
                        case "cookies": {
                            Iterator<Map.Entry<String, JsonNode>> cit = value.fields();
                            while (cit.hasNext()) {
                                Map.Entry<String, JsonNode> cookie = cit.next();
                                builder.cookie(cookie.getKey(), cookie.getValue().asText());
                            }
                            continue block53;
                        }
                        case "method": {
                            builder.method(HttpMethod.valueOf(value.asText().toUpperCase()));
                            break;
                        }
                        case "data": {
                            builder.data(value.asText());
                            break;
                        }
                        case "form": {
                            Iterator<Map.Entry<String, JsonNode>> fit = value.fields();
                            while (fit.hasNext()) {
                                Map.Entry<String, JsonNode> formField = fit.next();
                                builder.form(formField.getKey(), formField.getValue().asText());
                            }
                            continue block53;
                        }
                        case "url": {
                            this.url = value.asText();
                        }
                    }
                }
                jCurl = builder.build();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | ArrayIndexOutOfBoundsException | ClassCastException | NumberFormatException e) {
                    System.err.println("Couldn't parse config file " + config + ": " + e.getMessage());
                    System.exit(1);
                    return null;
                }
            }
            input.close();
            return jCurl;
        }

        private void printUsage() {
            System.out.format("JCurl: JSON-aware Java cURL%n%n", new Object[0]);
            System.out.format("Usage: jcurl [options...] <URL>%n", new Object[0]);
            System.out.format("Sets 'Content-Type: application/json' by default unless noted otherwise. To change the request content type, use '-H Content-Type your/mimetype'.%n", new Object[0]);
            System.out.format("%nSSL options:%n", new Object[0]);
            this.printOption("-keystore", "The keystore containing the certificate to use for authentication.");
            this.printOption("-storepass", "The keystore password.");
            this.printOption("-storetype", "The keystore type. Supported values: jks, jceks, pkcs11, pkcs12, bks, dks, windows-my.");
            this.printOption("-truststore", "The truststore containing the server certificate. If unspecified, the default Java truststore (cacerts) is used.");
            this.printOption("-trustpass", "The truststore password.");
            this.printOption("-trusttype", "The truststore type. See \"-storetype\" for supported values.");
            this.printOption("-k, -insecure", "Disable checks for an HTTPS request. Combines -no-verify-hostname and -no-check-certificate.");
            this.printOption("-no-verify-hostname", "Disable SSL hostname verification.");
            this.printOption("-no-check-certificate", "Disable SSL certificate verification.");
            System.out.format("%nRequest options:%n", new Object[0]);
            this.printOption("-H, -header KEY VALUE", "Send a custom header with the request. Example: -H Content-Type application/json.");
            this.printOption("-d, -data DATA", "Send a POST request with DATA as request body. Example: -data '{\"message\": \"Hello world!\", \"format\": \"TEXT\"}'.");
            this.printOption("-q, -query KEY VALUE", "Set request query parameters as \"KEY=VALUE\" paris separated by \"&\". Can be specified multiple times.");
            this.printOption("-F, -form KEY VALUE", "Send a POST request with data as \"KEY=VALUE\" pairs corresponding to a HTML form. To specify a file, precede the file name with \"@\" (example: -F file @/my/test/file.txt). Can be specified multiple times. Sets 'Content-Type: multipart/form-data'.");
            this.printOption("-b, -cookie KEY VALUE", "Set cookies used by the request. Can be specified multiple times.");
            this.printOption("-c, -extract-cookies", "Extract cookies returned by the call and return as \"NAME=VALUE\". If multiple cookies are returned, each is output on a new line.");
            this.printOption("-post", "Send a POST request without request body. If neither -post nor -data is specified, sends a GET request.");
            this.printOption("-X, -request METHOD", "Set the HTTP METHOD for the request. Supported values: GET, POST, PUT, DELETE, HEAD, CONNECT, OPTIONS.");
            this.printOption("-http STATUS", "Add HTTP STATUS as an expected response code. By default only HTTP 200 is expected as correct status.");
            System.out.format("%nConnection options:%n", new Object[0]);
            this.printOption("-x, -proxy", "Proxy the request through the specified URL. Applies to all protocols unless excluded with \"-noproxy\". Example: -proxy https://my.proxy.com:8080.");
            this.printOption("-noproxy", "Bypass the proxy set by -x for the specified list of |-separated hosts. Supports wildcards. Example: -noproxy my.host.org|*.otherhost.net.");
            this.printOption("-connect-timeout", "How long to wait, in seconds, for a connection to the remote resource. Defaults to infinity.");
            this.printOption("-read-timeout", "How long to wait, in seconds, for a response from the remote resource. Defaults to infinity.");
            System.out.format("%nOutput options:%n", new Object[0]);
            this.printOption("-t LABEL NODE", "Extract NODE from a JSON object returned by the call and return as \"LABEL=NODE\". Use \".\" to navigate within the JSON tree. Example: -t uid userSystemInfo.id (returns \"uid=12345\").");
            this.printOption("-a NODE", "Iterate over a JSON array of objects returned by the call content and extract the value of NODE. See -t for more details.");
            this.printOption("-v", "Verbose output. Will display request and response details.");
            this.printOption("-vv", "Very verbose output. Will display certificate details.");
            this.printOption("-vvv", "Very very verbose output. Turns on SSL debugging.");
            System.out.format("%nGeneral options:%n", new Object[0]);
            this.printOption("-K, -config", "Read request parameters from a JSON file. The format of the config file is \"parameter\":\"value\"; multivalued paramters (\"headers\", \"form\", \"extract\") should be JSON arrays. To display a sample config file, run jcurl -h config.");
            System.out.format("%n", new Object[0]);
            this.printOption("-h, -help", "Display this usage text.");
        }

        private void printConfigSample() {
            System.out.format("{%n", new Object[0]);
            System.out.format("    \"keystore\"  : \"user.p12\",%n", new Object[0]);
            System.out.format("    \"storepass\" : \"changeit\",%n", new Object[0]);
            System.out.format("    \"storetype\" : \"pkcs12\",%n", new Object[0]);
            System.out.format("    \"truststore\": \"server.p12\",%n", new Object[0]);
            System.out.format("    \"trustpass\" : \"changeit\",%n", new Object[0]);
            System.out.format("    \"trusttype\" : \"pkcs12\",%n", new Object[0]);
            System.out.format("    \"proxy\"     : \"https://proxy.example.com:443\",%n", new Object[0]);
            System.out.format("    \"noproxy\"   : \"https://localhost.com:8443\",%n", new Object[0]);
            System.out.format("    \"insecure\"  : false,%n", new Object[0]);
            System.out.format("    \"no-check-certificate\": false,%n", new Object[0]);
            System.out.format("    \"no-verify-hostname\"  : false,%n", new Object[0]);
            System.out.format("    \"connect-timeout\"     : 10,%n", new Object[0]);
            System.out.format("    \"read-timeout\"        : 10,%n", new Object[0]);
            System.out.format("    \"headers\"   : {%n", new Object[0]);
            System.out.format("      \"Content-Type\"   : \"application/json\",%n", new Object[0]);
            System.out.format("      \"Accept-Charset\" : \"utf-8\"%n", new Object[0]);
            System.out.format("    },%n", new Object[0]);
            System.out.format("    \"method\"    : \"post\",%n", new Object[0]);
            System.out.format("    \"data\"      : \"{\\\"message\\\":\\\"Ping\\\",\\\"format\\\":\\\"TEXT\\\"}\",%n", new Object[0]);
            System.out.format("    \"form\"      : {%n", new Object[0]);
            System.out.format("      \"file\" : \"@/my/test/file.txt\"%n", new Object[0]);
            System.out.format("    },%n", new Object[0]);
            System.out.format("    \"url\"       : \"https://localhost.com:8443\",%n", new Object[0]);
            System.out.format("    \"verbosity\" : 1,%n", new Object[0]);
            System.out.format("    \"extract\"   : {%n", new Object[0]);
            System.out.format("      \"uid\"  : \"userSystemInfo.id\"%n", new Object[0]);
            System.out.format("    }%n", new Object[0]);
            System.out.format("}%n", new Object[0]);
        }

        private void printOption(String option, String desc) {
            System.out.format("%-26s %s%n", option, desc);
        }
    }

    public static class Builder {
        private JCurl instance;

        private Builder() {
            HttpsURLConnection.setDefaultHostnameVerifier(DEFAULT_HOSTNAME_VERIFIER);
            this.instance = new JCurl();
        }

        public Builder method(HttpMethod method) {
            this.instance.method = method;
            return this;
        }

        public Builder data(String payload) {
            this.instance.data = payload;
            this.instance.method = HttpMethod.POST;
            return this;
        }

        public Builder header(String name, String value) {
            if (name.toLowerCase().equals("content-type")) {
                this.instance.contentType = value.toLowerCase();
            } else {
                this.instance.headerMap.put(name, value);
            }
            return this;
        }

        public Builder form(String name, String value) {
            this.instance.formMap.put(name, value);
            this.instance.method = HttpMethod.POST;
            return this;
        }

        public Builder query(String name, String value) {
            this.instance.queryMap.put(name, value);
            return this;
        }

        public Builder cookie(String name, String value) {
            this.instance.cookieMap.put(name, value);
            return this;
        }

        public Builder extractCookies(boolean extract) {
            this.instance.extractCookies = extract;
            return this;
        }

        public Builder extract(String label, String node) {
            this.instance.tagMap.put(label, node);
            return this;
        }

        public Builder extract(String node) {
            this.instance.tagList.add(node);
            return this;
        }

        public Builder expect(int expectedStatus) {
            this.instance.expectedResponseSet.add(expectedStatus);
            return this;
        }

        public Builder verbosity(int level) {
            this.instance.verbosity = level;
            return this;
        }

        public Builder keystore(String store) {
            this.instance.keyStore = store;
            return this;
        }

        public Builder storetype(String type) {
            this.instance.storeType = type;
            return this;
        }

        public Builder storepass(String pass) {
            this.instance.storePass = pass;
            return this;
        }

        public Builder truststore(String store) {
            this.instance.trustStore = store;
            return this;
        }

        public Builder trusttype(String type) {
            this.instance.trustType = type;
            return this;
        }

        public Builder trustpass(String pass) {
            this.instance.trustPass = pass;
            return this;
        }

        public Builder proxy(String proxy) throws MalformedURLException {
            URL url = new URL(proxy);
            this.instance.proxyHost = url.getHost();
            this.instance.proxyPort = String.valueOf(url.getPort());
            return this;
        }

        public Builder nonProxyHosts(String hosts) {
            this.instance.nonProxyHosts = hosts;
            return this;
        }

        public Builder insecure(boolean disableChecks) {
            if (disableChecks) {
                this.trustAllHostnames(true);
                this.trustAllCertificates(true);
            }
            return this;
        }

        public Builder trustAllHostnames(boolean disableChecks) {
            this.instance.trustAllHostnames = disableChecks;
            if (disableChecks) {
                HttpsURLConnection.setDefaultHostnameVerifier(new AllValidatingHostnameVerifier());
            }
            return this;
        }

        public Builder trustAllCertificates(boolean disableChecks) {
            this.instance.trustAllCerts = disableChecks;
            return this;
        }

        public Builder connectTimeout(int milliseconds) {
            this.instance.connectTimeout = milliseconds;
            return this;
        }

        public Builder readTimeout(int milliseconds) {
            this.instance.readTimeout = milliseconds;
            return this;
        }

        public Builder url(String url) {
            this.instance.url = url;
            return this;
        }

        public JCurl build() {
            this.instance.expectedResponseSet.add(200);
            this.setSystemProperty("javax.net.ssl.keyStore", this.instance.keyStore);
            this.setSystemProperty("javax.net.ssl.keyStoreType", this.instance.storeType);
            this.setSystemProperty("javax.net.ssl.keyStorePassword", this.instance.storePass);
            this.setSystemProperty("javax.net.ssl.trustStore", this.instance.trustStore);
            this.setSystemProperty("javax.net.ssl.trustStoreType", this.instance.trustType);
            this.setSystemProperty("javax.net.ssl.trustStorePassword", this.instance.trustPass);
            this.setSystemProperty("http.proxyHost", this.instance.proxyHost);
            this.setSystemProperty("http.proxyPort", this.instance.proxyPort);
            this.setSystemProperty("https.proxyHost", this.instance.proxyHost);
            this.setSystemProperty("https.proxyPort", this.instance.proxyPort);
            this.setSystemProperty("https.nonProxyHosts", this.instance.nonProxyHosts);
            if (this.instance.verbosity >= 3) {
                System.setProperty("javax.net.debug", "ssl");
            }
            HttpsURLConnection.setDefaultSSLSocketFactory((SSLSocketFactory)SSLSocketFactory.getDefault());
            this.initSSLContext();
            return this.instance;
        }

        private void initSSLContext() {
            try {
                FileInputStream fis;
                KeyManager[] keyManagers = null;
                TrustManager[] trustManagers = null;
                if (this.instance.keyStore != null) {
                    try {
                        fis = new FileInputStream(this.instance.keyStore);
                        try {
                            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                            String ksType = this.instance.storeType != null ? this.instance.storeType : "pkcs12";
                            KeyStore ks = KeyStore.getInstance(ksType);
                            ks.load(fis, this.instance.storePass.toCharArray());
                            kmf.init(ks, this.instance.storePass.toCharArray());
                            keyManagers = kmf.getKeyManagers();
                        }
                        finally {
                            ((InputStream)fis).close();
                        }
                    }
                    catch (IOException | KeyStoreException | UnrecoverableKeyException | CertificateException e) {
                        System.err.println("Failed to initialize keystore: " + e.getMessage());
                    }
                }
                if (this.instance.trustAllCerts) {
                    trustManagers = new TrustManager[]{new AllTrustingTrustManager()};
                } else if (this.instance.trustStore != null) {
                    try {
                        fis = new FileInputStream(this.instance.trustStore);
                        try {
                            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                            String tsType = this.instance.trustType != null ? this.instance.trustType : KeyStore.getDefaultType();
                            KeyStore ts = KeyStore.getInstance(tsType);
                            ts.load(fis, this.instance.trustPass.toCharArray());
                            tmf.init(ts);
                            trustManagers = tmf.getTrustManagers();
                        }
                        finally {
                            ((InputStream)fis).close();
                        }
                    }
                    catch (IOException | KeyStoreException | CertificateException e) {
                        System.err.println("Failed to initialize truststore: " + e.getMessage());
                    }
                }
                SSLContext context = SSLContext.getInstance("SSL");
                context.init(keyManagers, trustManagers, new SecureRandom());
                SSLContext.setDefault(context);
                HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                System.err.println("Failed to initialize SSL context: " + e.getMessage());
            }
        }

        private void setSystemProperty(String property, String value) {
            if (value != null) {
                System.setProperty(property, value);
            } else {
                System.clearProperty(property);
            }
        }
    }

    public static enum HttpMethod {
        GET,
        POST,
        PUT,
        DELETE,
        HEAD,
        CONNECT,
        OPTIONS;

    }
}

