/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.apps.authentication.jwt.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import java.util.Objects;
import org.symphonyoss.symphony.apps.authentication.jwt.model.JwtUser;

public class JwtPayload {
    @JsonProperty(value="aud")
    private String applicationId;
    @JsonProperty(value="iss")
    private String companyName;
    @JsonProperty(value="sub")
    private String userId;
    @JsonProperty(value="exp")
    private Long expirationDateInSeconds;
    private JwtUser user;

    public JwtPayload() {
    }

    public JwtPayload(String applicationId, String companyName, String userId, Long expirationDateInSeconds, JwtUser user) {
        this.applicationId = applicationId;
        this.companyName = companyName;
        this.userId = userId;
        this.expirationDateInSeconds = expirationDateInSeconds;
        this.user = user;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Long getExpirationDateInSeconds() {
        return this.expirationDateInSeconds;
    }

    public void setExpirationDateInSeconds(Long expirationDateInSeconds) {
        this.expirationDateInSeconds = expirationDateInSeconds;
    }

    public JwtUser getUser() {
        return this.user;
    }

    public void setUser(JwtUser user) {
        this.user = user;
    }

    public Date getExpirationDate() {
        if (this.expirationDateInSeconds == null || this.expirationDateInSeconds == 0L) {
            return null;
        }
        return new Date(Long.valueOf(this.expirationDateInSeconds + "000"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JwtPayload that = (JwtPayload)o;
        return Objects.equals(this.applicationId, that.applicationId) && Objects.equals(this.companyName, that.companyName) && Objects.equals(this.userId, that.userId) && Objects.equals(this.expirationDateInSeconds, that.expirationDateInSeconds) && Objects.equals(this.user, that.user);
    }

    public int hashCode() {
        return Objects.hash(this.applicationId, this.companyName, this.userId, this.expirationDateInSeconds, this.user);
    }
}

