/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.apps.authentication.certificate;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.symphony.apps.authentication.certificate.PodCertificateClient;
import org.symphonyoss.symphony.apps.authentication.certificate.exception.PodCertificateException;
import org.symphonyoss.symphony.apps.authentication.certificate.model.PodCertificate;
import org.symphonyoss.symphony.apps.authentication.endpoints.ServicesInfoProvider;
import org.symphonyoss.symphony.apps.authentication.endpoints.ServicesInfoProviderFactory;
import org.symphonyoss.symphony.apps.authentication.json.JsonParser;
import org.symphonyoss.symphony.apps.authentication.json.JsonParserFactory;

public class PodCertificateJerseyClient
implements PodCertificateClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(PodCertificateJerseyClient.class);
    private static final String POD_CERT_PATH = "v1/podcert";
    private final Integer connectTimeout;
    private final Integer readTimeout;
    private ServicesInfoProviderFactory providerFactory = ServicesInfoProviderFactory.getInstance();
    private JsonParserFactory jsonParserFactory = JsonParserFactory.getInstance();
    private ClientBuilder clientBuilder = ClientBuilder.newBuilder();

    public PodCertificateJerseyClient(Integer connectTimeout, Integer readTimeout) {
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    private Client initHttpClient() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.property("jersey.config.client.connectTimeout", (Object)this.connectTimeout);
        clientConfig.property("jersey.config.client.readTimeout", (Object)this.readTimeout);
        return this.clientBuilder.withConfig((Configuration)clientConfig).build();
    }

    @Override
    public PodCertificate getPodPublicCertificate() throws PodCertificateException {
        try (Client client = this.initHttpClient();){
            ServicesInfoProvider provider = (ServicesInfoProvider)this.providerFactory.getComponent();
            WebTarget target = client.target(provider.getPodBaseUrl()).path(POD_CERT_PATH);
            Response response = target.request().accept(new String[]{"*/*"}).get();
            if (Response.Status.OK.getStatusCode() == response.getStatus()) {
                String json = (String)response.readEntity(String.class);
                JsonParser parser = (JsonParser)this.jsonParserFactory.getComponent();
                PodCertificate podCertificate = parser.writeToObject(json, PodCertificate.class);
                return podCertificate;
            }
            LOGGER.error("Fail to retrieve POD certificate. HTTP Status: " + response.toString());
        }
        throw new PodCertificateException("Fail to retrieve POD certificate");
    }
}

