/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.apps.authentication.servlets;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.symphonyoss.symphony.apps.authentication.AppAuthenticationService;
import org.symphonyoss.symphony.apps.authentication.servlets.AppBaseServlet;
import org.symphonyoss.symphony.apps.authentication.servlets.model.ErrorResponse;
import org.symphonyoss.symphony.apps.authentication.tokens.model.AppToken;

public class TokensValidationServlet
extends AppBaseServlet {
    private static final String UNAUTHORIZED_PAIR = "The provided application token %s and Symphony token %s are invalid. Please restart the authentication process";
    private AppAuthenticationService authenticationService = new AppAuthenticationService();

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AppToken reqPayload = this.readPostJsonObject(request, AppToken.class);
        String appId = reqPayload.getAppId();
        String appToken = reqPayload.getAppToken();
        String symphonyToken = reqPayload.getSymphonyToken();
        if (appId == null) {
            this.missingParameter(response, "appId");
            return;
        }
        if (appToken == null) {
            this.missingParameter(response, "appToken");
            return;
        }
        if (symphonyToken == null) {
            this.missingParameter(response, "symphonyToken");
            return;
        }
        boolean isValid = this.authenticationService.isValidTokenPair(appToken, symphonyToken);
        if (isValid) {
            AppToken result = new AppToken(appId, appToken, symphonyToken);
            this.writeJsonObject(response, result, 200);
        } else {
            ErrorResponse errorResponse = new ErrorResponse();
            errorResponse.setCode(401);
            errorResponse.setMessage(String.format(UNAUTHORIZED_PAIR, appToken, symphonyToken));
            this.writeJsonObject(response, errorResponse, errorResponse.getCode());
        }
    }
}

