/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.apps.authentication.servlets;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.symphonyoss.symphony.apps.authentication.jwt.JwtService;
import org.symphonyoss.symphony.apps.authentication.jwt.exception.JwtProcessingException;
import org.symphonyoss.symphony.apps.authentication.jwt.model.JwtPayload;
import org.symphonyoss.symphony.apps.authentication.servlets.AppBaseServlet;
import org.symphonyoss.symphony.apps.authentication.servlets.model.ErrorResponse;
import org.symphonyoss.symphony.apps.authentication.servlets.model.JwtInfo;

public class JwtValidationServlet
extends AppBaseServlet {
    private static final Integer DEFAULT_CACHE_TIMEOUT = 60;
    private static final Integer DEFAULT_CACHE_SIZE = 1000;
    private static final String UNAUTHORIZED_JWT = "The provided JWT token '%s' is invalid and therefore unauthorized. More information: %s.";
    private JwtService service = new JwtService(DEFAULT_CACHE_TIMEOUT, DEFAULT_CACHE_SIZE);

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        JwtInfo reqPayload = this.readPostJsonObject(request, JwtInfo.class);
        String jwt = reqPayload.getJwt();
        if (jwt == null) {
            this.missingParameter(response, "jwt");
            return;
        }
        try {
            JwtPayload payload = this.service.parseJwtPayload(jwt);
            String userId = payload.getUserId();
            this.writeResponse(response, userId, 200);
        }
        catch (JwtProcessingException e) {
            ErrorResponse errorResponse = new ErrorResponse();
            errorResponse.setCode(401);
            errorResponse.setMessage(String.format(UNAUTHORIZED_JWT, jwt, e.getMessage()));
            this.writeJsonObject(response, errorResponse, errorResponse.getCode());
        }
    }
}

