/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.apps.authentication.servlets;

import java.io.BufferedReader;
import java.io.IOException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.symphonyoss.symphony.apps.authentication.json.JsonParser;
import org.symphonyoss.symphony.apps.authentication.json.JsonParserFactory;
import org.symphonyoss.symphony.apps.authentication.servlets.model.ErrorResponse;

public abstract class AppBaseServlet
extends HttpServlet {
    private static final String MISSING_PARAMETER = "Missing the required parameter %s";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String APPLICATION_JSON = "application/json";

    protected String readPostBody(HttpServletRequest request) throws IOException {
        StringBuilder buffer = new StringBuilder();
        try (BufferedReader reader = request.getReader();){
            String line;
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
        }
        return buffer.toString();
    }

    protected <T> T readPostJsonObject(HttpServletRequest request, Class<T> clazz) throws IOException {
        JsonParser parser = (JsonParser)JsonParserFactory.getInstance().getComponent();
        String body = this.readPostBody(request);
        return (T)parser.writeToObject(body, clazz);
    }

    protected void writeResponse(HttpServletResponse response, String payload, int status) throws IOException {
        response.setStatus(status);
        response.getWriter().write(payload);
    }

    protected void writeJsonObject(HttpServletResponse response, Object payload, int status) throws IOException {
        JsonParser parser = (JsonParser)JsonParserFactory.getInstance().getComponent();
        String content = parser.writeToString(payload);
        this.writeResponse(response, content, status);
        response.addHeader(CONTENT_TYPE, APPLICATION_JSON);
    }

    protected void missingParameter(HttpServletResponse response, String param) throws IOException {
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setCode(400);
        errorResponse.setMessage(String.format(MISSING_PARAMETER, param));
        this.writeJsonObject(response, errorResponse, errorResponse.getCode());
    }
}

