/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.apps.authentication.servlets;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.symphonyoss.symphony.apps.authentication.AppAuthenticationException;
import org.symphonyoss.symphony.apps.authentication.AppAuthenticationService;
import org.symphonyoss.symphony.apps.authentication.servlets.AppBaseServlet;
import org.symphonyoss.symphony.apps.authentication.servlets.model.AppInfo;
import org.symphonyoss.symphony.apps.authentication.servlets.model.ErrorResponse;
import org.symphonyoss.symphony.apps.authentication.tokens.model.AppToken;

public class AppAuthenticationServlet
extends AppBaseServlet {
    private static final String UNAUTHORIZED_MESSAGE = "The provided POD ID %s is not the same used by this application.";
    private AppAuthenticationService authenticationService = new AppAuthenticationService();

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AppInfo reqPayload = this.readPostJsonObject(request, AppInfo.class);
        String appId = reqPayload.getAppId();
        if (appId == null) {
            this.missingParameter(response, "appId");
            return;
        }
        try {
            AppToken appToken = this.authenticationService.authenticate(appId);
            this.writeJsonObject(response, appToken, 200);
        }
        catch (AppAuthenticationException e) {
            ErrorResponse errorResponse = new ErrorResponse();
            errorResponse.setCode(500);
            errorResponse.setMessage(e.getMessage());
            this.writeJsonObject(response, errorResponse, errorResponse.getCode());
        }
    }
}

