/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.apps.authentication;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.ClientConfig;
import org.symphonyoss.symphony.apps.authentication.AppAuthenticationException;
import org.symphonyoss.symphony.apps.authentication.endpoints.ServicesInfoProvider;
import org.symphonyoss.symphony.apps.authentication.endpoints.ServicesInfoProviderFactory;
import org.symphonyoss.symphony.apps.authentication.json.JsonParser;
import org.symphonyoss.symphony.apps.authentication.json.JsonParserFactory;
import org.symphonyoss.symphony.apps.authentication.keystore.KeystoreProvider;
import org.symphonyoss.symphony.apps.authentication.keystore.KeystoreProviderFactory;
import org.symphonyoss.symphony.apps.authentication.keystore.model.KeystoreSettings;
import org.symphonyoss.symphony.apps.authentication.tokens.model.AppToken;

public class AppAuthenticationApiClient {
    private static final String AUTHENTICATE_PATH = "/v1/authenticate/extensionApp";
    private static final Integer DEFAULT_CONNECT_TIMEOUT = 10000;
    private static final Integer DEFAULT_READ_TIMEOUT = 10000;
    private ServicesInfoProviderFactory servicesInfoProviderFactory = ServicesInfoProviderFactory.getInstance();
    private KeystoreProviderFactory keystoreProviderFactory = KeystoreProviderFactory.getInstance();
    private JsonParserFactory jsonParserFactory = JsonParserFactory.getInstance();
    private ClientBuilder clientBuilder = ClientBuilder.newBuilder();

    private Client initHttpClient(String appId) {
        KeystoreProvider keystoreProvider = (KeystoreProvider)this.keystoreProviderFactory.getComponent();
        KeystoreSettings appKeystore = keystoreProvider.getApplicationKeystore(appId);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.property("jersey.config.client.connectTimeout", (Object)DEFAULT_CONNECT_TIMEOUT);
        clientConfig.property("jersey.config.client.readTimeout", (Object)DEFAULT_READ_TIMEOUT);
        return this.clientBuilder.withConfig((Configuration)clientConfig).keyStore(appKeystore.getData(), appKeystore.getPassword()).build();
    }

    public AppToken authenticate(String appId, String appToken) throws AppAuthenticationException {
        try (Client client = this.initHttpClient(appId);){
            ServicesInfoProvider provider = (ServicesInfoProvider)this.servicesInfoProviderFactory.getComponent();
            WebTarget target = client.target(provider.getSessionAuthBaseUrl()).path(AUTHENTICATE_PATH);
            AppToken token = new AppToken();
            token.setAppToken(appToken);
            Response response = target.request().accept(new String[]{"*/*"}).post(Entity.json((Object)token));
            if (Response.Status.OK.getStatusCode() == response.getStatus()) {
                String json = (String)response.readEntity(String.class);
                JsonParser parser = (JsonParser)this.jsonParserFactory.getComponent();
                AppToken appToken2 = (AppToken)parser.writeToObject(json, AppToken.class);
                return appToken2;
            }
            try {
                throw new AppAuthenticationException("Failure to authenticate app: " + appId + " due to " + "http error: " + response.toString());
            }
            catch (AppAuthenticationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AppAuthenticationException("Unexpected error to authenticate app: " + appId, e);
            }
        }
    }
}

