/*
 * Decompiled with CFR 0.152.
 */
package org.swixml.list;

import java.awt.Component;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.swixml.LogAware;

public class CustomListCellRenderer
extends JLabel
implements ListCellRenderer,
LogAware {
    public CustomListCellRenderer() {
        Application app = Application.getInstance();
        try {
            ResourceMap res = app.getContext().getResourceMap();
            Icon icon = res.getIcon("listIcon");
            if (null != icon) {
                super.setIconTextGap(6);
                super.setIcon(icon);
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "icon doesn't exist", ex);
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String s = value.toString();
        this.setText(s);
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        this.setOpaque(true);
        return this;
    }
}

