/*
 * Decompiled with CFR 0.152.
 */
package org.swixml;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TreeSelectionEvent;
import org.jdesktop.application.Action;
import org.jdesktop.observablecollections.ObservableCollections;
import org.swixml.list.CustomListCellRenderer;
import org.swixml.table.SimpleBean;
import org.swixml.tree.TestTreeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplorerFrame
extends JFrame {
    public JTable testTable;
    final CustomListCellRenderer listRenderer = new CustomListCellRenderer();
    boolean connected = false;
    List<SimpleBean> myData = ObservableCollections.observableList(new ArrayList());
    final List<String> comboList = ObservableCollections.observableList(Arrays.asList("item1", "item2", "item3"));
    TestTreeModel myTree = new TestTreeModel();
    private String testValue = "TEST";
    private String message = "";

    public final CustomListCellRenderer getListRenderer() {
        return this.listRenderer;
    }

    public final String getMessage() {
        return this.message;
    }

    public final void setMessage(String value) {
        String oldValue = this.message;
        this.message = value;
        this.firePropertyChange("message", oldValue, this.message);
    }

    public Class<?> getMyDataClass() {
        return SimpleBean.class;
    }

    public final List<String> getComboList() {
        return this.comboList;
    }

    public List<SimpleBean> getMyData() {
        return this.myData;
    }

    public TestTreeModel getMyTree() {
        return this.myTree;
    }

    public Dimension getFrameSize() {
        return new Dimension(100, 600);
    }

    @Action
    public void comboAction(ActionEvent e) {
        JComboBox cb = (JComboBox)e.getSource();
        Object item = cb.getSelectedItem();
        if (item != null) {
            System.out.printf("comboAction source[%s]\n", item);
        }
    }

    @Action
    public void listAction(ActionEvent e) {
        ListSelectionEvent le = (ListSelectionEvent)e.getSource();
        JList list = (JList)le.getSource();
        Object item = list.getSelectedValue();
        if (item != null) {
            System.out.printf("listAction source:[%s]\n", item);
        }
    }

    @Action(enabledProperty="connected")
    public void test() {
        System.out.printf("hello world! %s\n", this.testValue);
        this.setTestValue("hello world!");
        this.firePropertyChange("testValue", null, null);
    }

    @Action
    public void selectNode(ActionEvent e) {
        TreeSelectionEvent ev = (TreeSelectionEvent)e.getSource();
        System.out.printf("selectNode path=%s\n", ev.getPath().toString());
        this.myData.add(new SimpleBean(ev.getPath().toString(), 0));
    }

    @Action
    public void selectRow(ActionEvent e) {
        ListSelectionEvent ev = (ListSelectionEvent)e.getSource();
        System.out.printf("selectRow firstIndex=%d lastIndex=%d valueIsAdjusting=%b\n", ev.getFirstIndex(), ev.getLastIndex(), ev.getValueIsAdjusting());
    }

    @Action
    public void show(ActionEvent e) {
        JComponent btn = (JComponent)e.getSource();
        this.setMessage(String.format("X:%s\nY:%s", btn.getClientProperty("X"), btn.getClientProperty("Y")));
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
        this.firePropertyChange("connected", null, (Object)connected);
    }

    public String getTestValue() {
        return this.testValue;
    }

    public void setTestValue(String testValue) {
        this.testValue = testValue;
        System.out.printf("updated %s\n", testValue);
    }
}

