/*
 * Decompiled with CFR 0.152.
 */
package org.swixml.examples.wizard;

import com.mysql.jdbc.Driver;
import java.awt.Component;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.jdesktop.application.Action;
import org.netbeans.spi.wizard.ResultProgressHandle;
import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardPage;
import org.netbeans.spi.wizard.WizardPanelNavResult;
import org.swixml.examples.wizard.DDLWizardApplication;
import org.swixml.examples.wizard.DDLWizardConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetJDBCInfoPage
extends WizardPage
implements DDLWizardConstants {
    public static final String DESCRIPTION = "JDBC connection";
    private static final String SELECT_DRIVER_MESSAGE = "please select the JDBC Driver";
    List<JDBCInfo> supportedDrivers = new ArrayList<JDBCInfo>(3);
    JComboBox cmbDriver;

    public SetJDBCInfoPage() {
        super("jdbc", DESCRIPTION);
        this.supportedDrivers.add(new JDBCInfo("<Select Driver>", null, null));
        this.supportedDrivers.add(new JDBCInfo("MySql Driver", Driver.class, "jdbc:mysql://mysql_server:3306/db_name"));
        this.supportedDrivers.add(new JDBCInfo("Oracle Driver", Void.class, "jdbc:oracle:thin:@//oracle_server:1521/oracle_db_name"));
        this.supportedDrivers.add(new JDBCInfo("MSSQL Driver", Void.class, "jdbc:sqlserver://SQL_SERVER:1433;databaseName=DB_NAME;integratedSecurity=false;"));
        this.supportedDrivers.add(new JDBCInfo("Derby DB [Embed]", EmbeddedDriver.class, "jdbc:derby:DB_PATH/DB_NAME;create=false"));
        this.setCreateDB(false);
        this.setFromDB(true);
    }

    protected void renderingPage() {
    }

    public WizardPanelNavResult allowBack(String stepName, Map settings, Wizard wizard) {
        return super.allowBack(stepName, settings, wizard);
    }

    public WizardPanelNavResult allowFinish(String stepName, Map settings, Wizard wizard) {
        return super.allowFinish(stepName, settings, wizard);
    }

    public WizardPanelNavResult allowNext(String stepName, Map settings, Wizard wizard) {
        return new OpenConnectionTask();
    }

    protected String validateContents(Component component, Object event) {
        if (this.cmbDriver == null || this.cmbDriver.getSelectedIndex() <= 0) {
            return SELECT_DRIVER_MESSAGE;
        }
        if (DDLWizardApplication.isEmpty(this.getConnectionUrl())) {
            return "Connection Url is required!";
        }
        return null;
    }

    public final boolean isCreateDB() {
        return Boolean.TRUE.equals(this.getWizardData("createDB"));
    }

    public final void setCreateDB(boolean createDB) {
        this.putWizardData("createDB", createDB);
        this.firePropertyChange("createDB", null, null);
    }

    public final boolean isFromDB() {
        return Boolean.TRUE.equals(this.getWizardData("fromDB"));
    }

    public final void setFromDB(boolean fromDB) {
        this.putWizardData("fromDB", fromDB);
        this.firePropertyChange("fromDB", null, null);
    }

    public final String getDriverClass() {
        return (String)this.getWizardData("driverClass");
    }

    public final void setDriverClass(String driverClass) {
        this.putWizardData("driverClass", driverClass);
        this.firePropertyChange("driverClass", null, null);
    }

    public final String getConnectionUrl() {
        return (String)this.getWizardData("connectionUrl");
    }

    public final void setConnectionUrl(String connectionUrl) {
        this.putWizardData("connectionUrl", connectionUrl);
        this.firePropertyChange("connectionUrl", null, null);
    }

    public final String getUser() {
        return (String)this.getWizardData("user");
    }

    public final void setUser(String user) {
        this.putWizardData("user", user);
    }

    public final String getPasswd() {
        return (String)this.getWizardData("password");
    }

    public final void setPasswd(String passwd) {
        this.putWizardData("password", passwd);
    }

    public final List<JDBCInfo> getSupportedDrivers() {
        return this.supportedDrivers;
    }

    public boolean isDataValid() {
        return this.cmbDriver != null && this.cmbDriver.getSelectedIndex() > 0 && null != this.getConnectionUrl();
    }

    @Action
    public void selectDriver() {
        int selectedIndex = this.cmbDriver.getSelectedIndex();
        if (selectedIndex > 0) {
            JDBCInfo selectedInfo = this.supportedDrivers.get(selectedIndex);
            this.setDriverClass(selectedInfo.getDriver());
            this.setConnectionUrl(selectedInfo.getConnectionUrl());
        } else {
            this.setDriverClass("");
            this.setConnectionUrl("");
        }
    }

    class OpenConnectionTask
    extends WizardPanelNavResult {
        OpenConnectionTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start(Map wizardData, ResultProgressHandle progress) {
            progress.setBusy("Connecting...");
            Connection conn = null;
            try {
                conn = DDLWizardApplication.getConnection(wizardData);
            }
            catch (Exception e) {
                progress.failed(e.getMessage(), true);
                return;
            }
            finally {
                DDLWizardApplication.closeConnection(conn);
            }
            progress.finished((Object)WizardPanelNavResult.PROCEED);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JDBCInfo {
        final Class<?> driver;
        final String connectionUrl;
        final String name;

        public JDBCInfo(String name, Class<?> driver, String connectionUrl) {
            this.name = name;
            this.driver = driver;
            this.connectionUrl = connectionUrl;
        }

        public String toString() {
            return this.name;
        }

        public final String getDriver() {
            return this.driver.getName();
        }

        public final String getConnectionUrl() {
            return this.connectionUrl;
        }
    }
}

