/*
 * Decompiled with CFR 0.152.
 */
package org.swixml.examples.wizard;

import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.sql.Connection;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.PlatformFactory;
import org.apache.ddlutils.io.DatabaseIO;
import org.apache.ddlutils.model.Database;
import org.jdesktop.application.Action;
import org.netbeans.spi.wizard.ResultProgressHandle;
import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardPage;
import org.netbeans.spi.wizard.WizardPanelNavResult;
import org.swixml.examples.wizard.DDLWizardApplication;
import org.swixml.examples.wizard.DDLWizardConstants;

public class SetDBSchema
extends WizardPage
implements DDLWizardConstants {
    private static final String WIZARD_MESSAGE = "Select DB Schema File";

    public SetDBSchema() {
        super("schema", "Generate Schema");
    }

    protected void renderingPage() {
        super.renderingPage();
        this.setGenerateSQL(true);
        this.setDropTables(true);
        this.setContinueOnError(true);
    }

    public WizardPanelNavResult allowFinish(String stepName, Map settings, Wizard wizard) {
        return new GenerateSchemaTask();
    }

    public WizardPanelNavResult allowNext(String stepName, Map settings, Wizard wizard) {
        return new GenerateSchemaTask();
    }

    protected String validateContents(Component component, Object event) {
        if (DDLWizardApplication.isEmpty(this.getSelectedFile())) {
            return WIZARD_MESSAGE;
        }
        return null;
    }

    public String getSelectedFile() {
        File dbSchema = this.getDbSchema();
        return null != dbSchema ? dbSchema.getPath() : null;
    }

    public final boolean isDropTables() {
        return Boolean.TRUE.equals(this.getWizardDataMap().get("dropTables"));
    }

    public final void setDropTables(boolean dropTables) {
        this.putWizardData("dropTables", dropTables);
        this.firePropertyChange("dropTables", null, null);
    }

    public final boolean isContinueOnError() {
        return Boolean.TRUE.equals(this.getWizardData("continueOnError"));
    }

    public final void setContinueOnError(boolean continueOnError) {
        this.putWizardData("continueOnError", continueOnError);
        this.firePropertyChange("continueOnError", null, null);
    }

    public final boolean isGenerateSQL() {
        return Boolean.TRUE.equals(this.getWizardData("generateSQL"));
    }

    public final void setGenerateSQL(boolean generateXML) {
        this.putWizardData("generateSQL", generateXML);
        this.firePropertyChange("generateSQL", null, null);
    }

    public final File getDbSchema() {
        return (File)this.getWizardData("dbSchema");
    }

    public final void setDbSchema(File dbSchema) {
        this.putWizardData("dbSchema", dbSchema);
        this.firePropertyChange("selectedFile", null, null);
    }

    public void setSQLFile(File value) {
        this.putWizardData("sqlFile", value);
    }

    public File getSQLFile() {
        return (File)this.getWizardData("sqlFile");
    }

    @Action
    public void selectFile() {
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("DB Schema (XML)", "xml");
        chooser.setFileFilter(filter);
        chooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        chooser.setFileSelectionMode(0);
        int returnVal = chooser.showOpenDialog((Component)((Object)this));
        if (returnVal == 0) {
            File file = chooser.getSelectedFile();
            String path = file.getPath();
            this.setDbSchema(file);
            this.setSQLFile(new File(path.substring(0, path.lastIndexOf(46)).concat(".sql")));
        }
    }

    class GenerateSchemaTask
    extends WizardPanelNavResult {
        GenerateSchemaTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start(Map settings, ResultProgressHandle progress) {
            progress.setBusy("Generating...");
            String driverClass = (String)settings.get("driverClass");
            String connectionUrl = (String)settings.get("connectionUrl");
            boolean dropTables = Boolean.TRUE.equals(settings.get("dropTables"));
            boolean continueOnError = Boolean.TRUE.equals(settings.get("continueOnError"));
            boolean generateSql = Boolean.TRUE.equals(settings.get("generateSQL"));
            File dbSchema = (File)settings.get("dbSchema");
            Connection conn = null;
            try {
                Database db = new DatabaseIO().read(dbSchema);
                settings.put("databaseModel", db);
                Platform platform = PlatformFactory.createNewPlatformInstance((String)driverClass, (String)connectionUrl);
                if (generateSql) {
                    String ddl = platform.getCreateTablesSql(db, dropTables, continueOnError);
                    FileWriter fw = new FileWriter((File)settings.get("sqlFile"));
                    fw.write(ddl);
                    fw.close();
                }
                conn = DDLWizardApplication.getConnection(settings);
                conn.setAutoCommit(true);
                platform.createTables(conn, db, dropTables, continueOnError);
                progress.finished((Object)WizardPanelNavResult.PROCEED);
                DDLWizardApplication.closeConnection(conn);
            }
            catch (Exception e) {
                progress.failed(String.format("Error on Database creation\n%s", e.getMessage()), true);
            }
            finally {
                DDLWizardApplication.closeConnection(conn);
            }
        }
    }
}

