/*
 * Decompiled with CFR 0.152.
 */
package org.swixml.examples.wizard;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.jdesktop.application.Application;
import org.netbeans.api.wizard.WizardDisplayer;
import org.netbeans.spi.wizard.Summary;
import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardBranchController;
import org.netbeans.spi.wizard.WizardException;
import org.netbeans.spi.wizard.WizardPage;
import org.swixml.examples.wizard.DDLWizardConstants;
import org.swixml.examples.wizard.GenerateBeanPage;
import org.swixml.examples.wizard.SetDBSchema;
import org.swixml.examples.wizard.SetJDBCInfoPage;
import org.swixml.jsr296.SwingApplication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDLWizardApplication
extends SwingApplication
implements DDLWizardConstants {
    private static final boolean USE_BRANCH = true;
    SetJDBCInfoPage page1 = new SetJDBCInfoPage();
    SetDBSchema page2 = new SetDBSchema();
    GenerateBeanPage page3 = new GenerateBeanPage();
    WizardPage.WizardResultProducer producer = new WizardPage.WizardResultProducer(){

        public Object finish(Map settings) throws WizardException {
            Map map = settings;
            String[] summary = new String[map.size()];
            int i = 0;
            for (Map.Entry e : map.entrySet()) {
                summary[i++] = String.format("%s=%s", e.getKey(), e.getValue());
            }
            return Summary.create((String[])summary, (Object)settings);
        }

        public boolean cancel(Map wizardData) {
            ((SwingApplication)Application.getInstance(SwingApplication.class)).getMainFrame().dispose();
            return true;
        }
    };

    public static boolean isEmpty(String value) {
        if (value == null) {
            return true;
        }
        if (value.length() == 0) {
            return true;
        }
        return value.trim().length() == 0;
    }

    public static Connection getConnection(Map<String, Object> wizardData) throws Exception {
        String driverClass = (String)wizardData.get("driverClass");
        String connectionUrl = (String)wizardData.get("connectionUrl");
        String user = (String)wizardData.get("user");
        String password = (String)wizardData.get("password");
        try {
            Class.forName(driverClass);
        }
        catch (ClassNotFoundException e) {
            throw new Exception("Error Loading Driver!");
        }
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(connectionUrl, user, password);
        }
        catch (SQLException e) {
            throw new Exception("Error opening connection !");
        }
        return conn;
    }

    public static void closeConnection(Connection conn) {
        if (null == conn) {
            return;
        }
        try {
            conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void startup() {
        try {
            this.render((Container)((Object)this.page1));
            this.render((Container)((Object)this.page2));
            this.render((Container)((Object)this.page3));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(null, "Fatal Error on render component!", "Error", 0);
            this.exit();
        }
        Wizard wizard = null;
        Brancher brancher = new Brancher();
        wizard = brancher.createWizard();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int w = 700;
        int h = 500;
        int x = (dim.width - w) / 2;
        int y = (dim.height - h) / 2;
        WizardDisplayer.showWizard((Wizard)wizard, (Rectangle)new Rectangle(x, y, w, h));
        ((SwingApplication)DDLWizardApplication.getInstance(SwingApplication.class)).getMainFrame().dispose();
    }

    protected void initialize(String[] args) {
        boolean nimbusLF = false;
        for (UIManager.LookAndFeelInfo laf : UIManager.getInstalledLookAndFeels()) {
            System.out.println(laf.getName());
            if (!"Nimbus".equals(laf.getName())) continue;
            try {
                UIManager.setLookAndFeel(laf.getClassName());
                nimbusLF = true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (!nimbusLF) {
            String lf = UIManager.getCrossPlatformLookAndFeelClassName();
            System.out.println(lf);
            try {
                UIManager.setLookAndFeel(lf);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        Application.launch(DDLWizardApplication.class, (String[])args);
    }

    class Brancher
    extends WizardBranchController {
        Wizard wizardCreateDb;
        Wizard wizardImportDb;

        protected Brancher() {
            super((WizardPage)DDLWizardApplication.this.page1);
            this.wizardCreateDb = WizardPage.createWizard((WizardPage[])new WizardPage[]{DDLWizardApplication.this.page2, DDLWizardApplication.this.page3}, (WizardPage.WizardResultProducer)DDLWizardApplication.this.producer);
            this.wizardImportDb = WizardPage.createWizard((WizardPage[])new WizardPage[]{DDLWizardApplication.this.page3}, (WizardPage.WizardResultProducer)DDLWizardApplication.this.producer);
        }

        protected Wizard getWizardForStep(String step, Map wizardData) {
            if ("jdbc".equalsIgnoreCase(step) && Boolean.TRUE.equals(wizardData.get("createDB"))) {
                return this.wizardCreateDb;
            }
            return this.wizardImportDb;
        }
    }
}

