/*
 * Decompiled with CFR 0.152.
 */
package org.swixml.contrib.gmap;

import Task.ProgressMonitor.InputStreamUIHookSupport;
import Task.ProgressMonitor.ProgressMonitorUtils;
import Task.ProgressMonitor.SwingUIHookAdapter;
import Task.Support.CoreSupport.ByteBuffer;
import Task.Support.GUISupport.ImageUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.SwingUtilities;
import org.swixml.LogUtil;
import org.swixml.contrib.gmap.MapLookup;
import org.swixml.contrib.gmap.MapMarker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleMapPanel
extends JPanel {
    private final MapLookup lookup = new MapLookup();
    private JLabel lblImageMap = new JLabel();
    final JProgressBar progressBar = new JProgressBar(0, 100);
    private boolean useInternalProgressBar = true;

    public GoogleMapPanel() {
        super(new BorderLayout());
        this.progressBar.setValue(this.progressBar.getMinimum());
        this.progressBar.setVisible(true);
        this.progressBar.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.progressBar.setStringPainted(true);
        this.add((Component)this.lblImageMap, "Center");
        this.lblImageMap.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
    }

    public final boolean isUseInternalProgressBar() {
        return this.useInternalProgressBar;
    }

    public final void setUseInternalProgressBar(boolean useInternalProgressBar) {
        this.useInternalProgressBar = useInternalProgressBar;
    }

    public final String getMapToolTipText() {
        return this.lblImageMap.getToolTipText();
    }

    public final void setMapToolTipText(String value) {
        this.lblImageMap.setToolTipText(value);
    }

    public final MapLookup getLookup() {
        return this.lookup;
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    private static <T extends Component> T findComponent(Container c, Class<T> type, String name) {
        for (int i = 0; i < c.getComponentCount(); ++i) {
            Component cc = c.getComponent(i);
            if (type.isInstance(cc) && (name == null || name.equalsIgnoreCase(cc.getName()))) {
                return (T)cc;
            }
            if (!(cc instanceof Container) || (cc = GoogleMapPanel.findComponent((Container)cc, type, name)) == null) continue;
            return (T)cc;
        }
        return null;
    }

    public static GoogleMapPanel find(Window w, String panelName) {
        return GoogleMapPanel.findComponent(w, GoogleMapPanel.class, panelName);
    }

    public static GoogleMapPanel find(Window w) {
        return GoogleMapPanel.find(w, null);
    }

    public void loadMap(String latitude, String longitude, int zoom, MapMarker ... markers) {
        this.loadMap(null, latitude, longitude, zoom, markers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMap(final JProgressBar externalProgressBar, String latitude, String longitude, int zoom, MapMarker ... markers) {
        final boolean useInternal = externalProgressBar == null && this.isUseInternalProgressBar();
        boolean useMonitor = externalProgressBar == null && !this.isUseInternalProgressBar();
        Dimension sz = new Dimension();
        if (useInternal || useMonitor) {
            this.getSize(sz);
        } else {
            this.lblImageMap.getSize(sz);
        }
        String uri = this.lookup.getMap(Double.parseDouble(latitude), Double.parseDouble(longitude), sz.width, sz.height, zoom, markers);
        try {
            URL url = new URL(uri);
            FilterInputStream is = null;
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.connect();
            if (useMonitor) {
                is = new ProgressMonitorInputStream(SwingUtilities.getWindowAncestor(this), "Loading Map .... ", conn.getInputStream());
            } else {
                SwingUIHookAdapter hook = new SwingUIHookAdapter();
                if (useInternal) {
                    this.add((Component)this.progressBar, "South");
                    this.doLayout();
                }
                hook.addRecieveStatusListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        if (useInternal) {
                            GoogleMapPanel.this.progressBar.setValue(ProgressMonitorUtils.parsePercentFrom(evt));
                            GoogleMapPanel.this.progressBar.setString(ProgressMonitorUtils.parseMessageFrom(evt));
                        } else {
                            externalProgressBar.setValue(ProgressMonitorUtils.parsePercentFrom(evt));
                            externalProgressBar.setString(ProgressMonitorUtils.parseMessageFrom(evt));
                        }
                    }
                });
                hook.addUnderlyingIOStreamInterruptedOrClosed(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                    }
                });
                is = new InputStreamUIHookSupport(InputStreamUIHookSupport.Type.RecvStatus, hook == null ? null : hook.getUIHook(), conn);
            }
            ByteBuffer data = new ByteBuffer(is);
            BufferedImage _img = ImageUtils.toCompatibleImage(ImageIO.read(data.getInputStream()));
            this.lblImageMap.setIcon(new ImageIcon(_img));
            if (useInternal) {
                this.remove(this.progressBar);
                this.revalidate();
            }
        }
        catch (IOException ioex) {
            String msg = String.format("error opening google map URI\n[%s]", uri);
            LogUtil.logger.warning(msg);
            this.lblImageMap.setText(msg);
        }
        catch (Exception e) {
            String msg = String.format("The URI is not an image. Data is downloaded, can't display it as an image.\n[%s]", uri);
            LogUtil.logger.warning(msg);
            this.lblImageMap.setText(msg);
        }
    }

    public static void main(String[] args) throws Exception {
        JFrame frame = new JFrame();
        GoogleMapPanel panel = new GoogleMapPanel();
        JProgressBar progressBar = new JProgressBar(0, 100);
        progressBar.setValue(progressBar.getMinimum());
        progressBar.setVisible(true);
        progressBar.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        progressBar.setStringPainted(true);
        panel.setMapToolTipText("THE MAP");
        frame.setDefaultCloseOperation(2);
        frame.setLayout(new BorderLayout());
        frame.add((Component)panel, "Center");
        frame.add((Component)progressBar, "South");
        frame.pack();
        frame.setSize(600, 600);
        frame.setVisible(true);
        GoogleMapPanel p = GoogleMapPanel.find(frame);
        p.setUseInternalProgressBar(false);
        p.loadMap("41.8500", "-87.6501", 11, new MapMarker[0]);
        Thread.sleep(5000L);
        p.loadMap(progressBar, "40.9166667", "14.7333333", 11, new MapMarker[0]);
        Thread.sleep(5000L);
        p.setUseInternalProgressBar(true);
        p.loadMap("45.4643", "9.1895", 11, new MapMarker[0]);
    }
}

