/*
 * Decompiled with CFR 0.152.
 */
package Task.Support.GUISupport;

import Task.Support.CoreSupport.ByteBuffer;
import Task.Support.CoreSupport.ZipObject;
import Task.Support.CoreSupport.ZipObjectException;
import Task.Support.GUISupport.DrawingUtils;
import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.SplashScreen;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.swixml.contrib.gmap.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageUtils {
    public static HashMap<String, BufferedImage> bufferedImageCache = new HashMap();
    public static ReadWriteLock bufferedImageCacheLock = new ReentrantReadWriteLock();

    public static Graphics2D g2(Graphics g) {
        return DrawingUtils.applySmoothDrawingSettings((Graphics2D)g.create());
    }

    public static Graphics2D g2plain(Graphics g) {
        return (Graphics2D)g.create();
    }

    public static Graphics2D g2(BufferedImage img) {
        return DrawingUtils.applySmoothDrawingSettings(img.createGraphics());
    }

    public static Graphics2D g2(SplashScreen img) {
        return DrawingUtils.applySmoothDrawingSettings(img.createGraphics());
    }

    public static ZipObject<ByteBuffer> encodeBufferedImage(BufferedImage img) throws IllegalArgumentException, IOException, ZipObjectException {
        Validate.notNull(img, "BufferedImage can not be null");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)img, "png", baos);
        return new ZipObject<ByteBuffer>(new ByteBuffer(baos.toByteArray()));
    }

    public static BufferedImage decodeBufferedImage(ZipObject<ByteBuffer> zipObject) throws IllegalArgumentException, IOException, ZipObjectException {
        Validate.notNull(zipObject, "ZipObject can not be null");
        ByteBuffer bb = zipObject.getObject();
        return ImageIO.read(bb.getInputStream());
    }

    public static float scaleToFit(int sourceW, int sourceH, int targetW, int targetH, boolean respectSourceAspectRatio) {
        if (respectSourceAspectRatio) {
            float scaleX = (float)targetW * 1.0f / ((float)sourceW * 1.0f);
            float scaleY = (float)targetH * 1.0f / ((float)sourceH * 1.0f);
            return scaleX < scaleY ? scaleX : scaleY;
        }
        return (float)sourceW * 1.0f / ((float)targetW * 1.0f);
    }

    public static Dimension scaleToFit(int sourceW, int sourceH, int targetW, int targetH) {
        float scaleToFitFactor = ImageUtils.scaleToFit(sourceW, sourceH, targetW, targetH, true);
        return new Dimension((int)(scaleToFitFactor * (float)sourceW * 1.0f), (int)(scaleToFitFactor * (float)sourceH * 1.0f));
    }

    public static BufferedImage getImageOfComponent(JComponent comp) {
        BufferedImage newImg = ImageUtils.createCompatibleImage(comp.getWidth(), comp.getHeight(), false);
        Graphics2D g2 = ImageUtils.g2(newImg);
        comp.paint(g2);
        g2.dispose();
        return newImg;
    }

    public static BufferedImage getImageOfComponent(JComponent comp, boolean opaque) {
        BufferedImage newImg = ImageUtils.createCompatibleImage(comp.getWidth(), comp.getHeight(), opaque);
        Graphics2D g2 = ImageUtils.g2(newImg);
        comp.paint(g2);
        g2.dispose();
        return newImg;
    }

    public static BufferedImage toCompatibleImage(BufferedImage image) {
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice d = e.getDefaultScreenDevice();
        GraphicsConfiguration c = d.getDefaultConfiguration();
        BufferedImage compatibleImage = c.createCompatibleImage(image.getWidth(), image.getHeight(), image.getTransparency());
        Graphics2D gImg = ImageUtils.g2(compatibleImage);
        gImg.drawImage((Image)image, 0, 0, null);
        gImg.dispose();
        return compatibleImage;
    }

    public static BufferedImage createCompatibleImage(int width, int height, boolean opaque) {
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice d = e.getDefaultScreenDevice();
        GraphicsConfiguration c = d.getDefaultConfiguration();
        BufferedImage compatibleImage = c.createCompatibleImage(width, height, opaque ? 1 : 3);
        return compatibleImage;
    }

    public static BufferedImage createCompatibleImage(int width, int height, int transparency) {
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice d = e.getDefaultScreenDevice();
        GraphicsConfiguration c = d.getDefaultConfiguration();
        BufferedImage compatibleImage = c.createCompatibleImage(width, height, transparency);
        return compatibleImage;
    }

    public static BufferedImage getCopyOfBufferedImage(BufferedImage img, boolean opaque) {
        BufferedImage newImg = ImageUtils.createCompatibleImage(img.getWidth(), img.getHeight(), opaque ? 1 : 3);
        Graphics2D g2 = ImageUtils.g2(newImg);
        g2.drawImage((Image)img, 0, 0, null);
        g2.dispose();
        return newImg;
    }

    public static BufferedImage getCopyOfBufferedImage(BufferedImage img) {
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage newImg = new BufferedImage(img.getWidth(), img.getHeight(), type);
        Graphics2D g2 = ImageUtils.g2(newImg);
        g2.drawImage((Image)img, 0, 0, null);
        g2.dispose();
        return newImg;
    }

    public BufferedImage createBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D gImg = ImageUtils.g2(bufferedImage);
        gImg.drawImage(image, 0, 0, null);
        gImg.dispose();
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage loadBufferedImage(String imageName, boolean blur, float translucency) throws ClassNotFoundException, IllegalArgumentException {
        Validate.notEmpty(imageName, "imageName can not be null or empty");
        if (translucency < 0.0f || translucency > 1.0f) {
            throw new IllegalArgumentException("transluceny is invalid");
        }
        BufferedImage bufImg = null;
        Lock readLock = bufferedImageCacheLock.readLock();
        try {
            readLock.lock();
            if (bufferedImageCache.containsKey(imageName)) {
                bufImg = bufferedImageCache.get(imageName);
            }
        }
        finally {
            readLock.unlock();
        }
        if (bufImg == null) {
            Lock writeLock = bufferedImageCacheLock.writeLock();
            try {
                writeLock.lock();
                bufImg = ImageUtils.toCompatibleImage(ImageIO.read(ClassLoader.getSystemResourceAsStream(imageName)));
                bufferedImageCache.put(imageName, bufImg);
            }
            catch (Exception e) {
                throw new ClassNotFoundException("'" + imageName + "' not found in classpath", e);
            }
            finally {
                writeLock.unlock();
            }
        }
        bufImg = blur ? DrawingUtils.getBlurredImage(bufImg) : bufImg;
        bufImg = translucency == 1.0f ? bufImg : DrawingUtils.getTranslucentImage(bufImg, translucency);
        return bufImg;
    }

    public static BufferedImage getScaledBufferedImage(BufferedImage img, int targetWidth, int targetHeight) throws IllegalArgumentException {
        Validate.notNull(img, "BufferedImage can not be null");
        try {
            return ImageUtils.createHighResThumbnail(img, targetWidth, targetHeight, true);
        }
        catch (Exception e) {
            return ImageUtils.createFastResizedCopy(img, targetWidth, targetHeight, true);
        }
    }

    public static BufferedImage getScaledBufferedImage(BufferedImage img, int targetWidth, int targetHeight, boolean blur, float translucency) throws IllegalArgumentException {
        Validate.notNull(img, "BufferedImage can not be null");
        BufferedImage bufImg = ImageUtils.getScaledBufferedImage(img, targetWidth, targetHeight);
        bufImg = blur ? DrawingUtils.getBlurredImage(bufImg) : bufImg;
        bufImg = translucency == 1.0f ? bufImg : DrawingUtils.getTranslucentImage(bufImg, translucency);
        return bufImg;
    }

    public static BufferedImage createFastResizedCopy(BufferedImage originalImage, int scaledWidth, int scaledHeight, boolean keepAspectRatio) {
        if (keepAspectRatio) {
            Dimension d = ImageUtils.scaleToFit(originalImage.getWidth(), originalImage.getHeight(), scaledWidth, scaledHeight);
            scaledWidth = d.width;
            scaledHeight = d.height;
        }
        int type = originalImage.getTransparency() == 1 ? 1 : 2;
        BufferedImage scaledBI = new BufferedImage(scaledWidth, scaledHeight, type);
        Graphics2D g = ImageUtils.g2(scaledBI);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        if (type == 2) {
            g.setComposite(AlphaComposite.Src);
        }
        g.drawImage(originalImage, 0, 0, scaledWidth, scaledHeight, null);
        g.dispose();
        return scaledBI;
    }

    public static BufferedImage createHighResThumbnail(BufferedImage image, int newWidth, int newHeight, boolean keepAspectRatio) {
        boolean isTranslucent;
        int width = image.getWidth();
        int height = image.getHeight();
        if (keepAspectRatio) {
            Dimension d = ImageUtils.scaleToFit(width, height, newWidth, newHeight);
            newWidth = d.width;
            newHeight = d.height;
        }
        boolean bl = isTranslucent = image.getTransparency() != 1;
        if (newWidth >= width || newHeight >= height) {
            throw new IllegalArgumentException("newWidth and newHeight cannot be greater than the image dimensions");
        }
        if (newWidth <= 0 || newHeight <= 0) {
            throw new IllegalArgumentException("newWidth and newHeight must be greater than 0");
        }
        BufferedImage thumb = image;
        BufferedImage temp = null;
        Graphics2D g2 = null;
        int previousWidth = width;
        int previousHeight = height;
        do {
            if (width > newWidth && (width /= 2) < newWidth) {
                width = newWidth;
            }
            if (height > newHeight && (height /= 2) < newHeight) {
                height = newHeight;
            }
            if (temp == null || isTranslucent) {
                temp = ImageUtils.createCompatibleImage(width, height, !isTranslucent);
                g2 = ImageUtils.g2(temp);
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            }
            g2.drawImage(thumb, 0, 0, width, height, 0, 0, previousWidth, previousHeight, null);
            previousWidth = width;
            previousHeight = height;
            thumb = temp;
        } while (width != newWidth || height != newHeight);
        g2.dispose();
        if (width != thumb.getWidth() || height != thumb.getHeight()) {
            temp = ImageUtils.createCompatibleImage(width, height, !isTranslucent);
            g2 = ImageUtils.g2(temp);
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.drawImage((Image)thumb, 0, 0, null);
            g2.dispose();
            thumb = temp;
        }
        return thumb;
    }

    public static Icon loadScaledBufferedIcon(String icon, int width, int height, boolean blur, float transparency) throws ClassNotFoundException {
        BufferedImage img = ImageUtils.loadBufferedImage(icon, blur, transparency);
        img = ImageUtils.getScaledBufferedImage(img, width, height);
        return new ImageIcon(img);
    }
}

