/*
 * Decompiled with CFR 0.152.
 */
package Task.Support.CoreSupport;

import Task.Support.CoreSupport.ByteBuffer;
import Task.Support.CoreSupport.TheStringTokenizer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.LogRecord;
import org.swixml.contrib.gmap.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private Utils() {
    }

    public static final String buildUri(String uri, HashMap<String, String> map) throws IllegalArgumentException {
        Validate.notNull(uri, "uri can not be null");
        StringBuilder sb = new StringBuilder();
        sb.append(uri);
        int i = 0;
        if (map != null && !map.isEmpty()) {
            for (String key : map.keySet()) {
                if (i == 0) {
                    sb.append("?");
                } else {
                    sb.append("&");
                }
                sb.append(key);
                sb.append("=");
                sb.append(map.get(key));
                ++i;
            }
        }
        return sb.toString();
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static void printDebugHeaderToConsole(String msg) {
        System.out.println(Utils.getDebugHeaderString(msg));
    }

    public static String getDebugHeaderString(String msg) {
        Validate.notNull(msg, "msg can not be null");
        StringBuilder lines = new StringBuilder();
        for (int i = 0; i < msg.length() + 6; ++i) {
            lines.append("-");
        }
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)lines).append("\n").append(":: ").append(msg).append(" ::").append("\n").append((CharSequence)lines);
        return sb.toString();
    }

    public static Object[] getObjectRay(Object ... args) {
        return args;
    }

    public static String listOfLogRecordToString(List<LogRecord> list) {
        StringBuilder sb = new StringBuilder();
        for (LogRecord rec : list) {
            sb.append("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX\n").append("LEVEL:").append(rec.getLevel()).append(", Name:").append(rec.getLoggerName()).append("\n").append("MSG:  ").append(rec.getMessage()).append("\n").append("EX:   ").append(rec.getThrown()).append("\n");
        }
        return sb.toString();
    }

    public static String mapToString(Map map) {
        StringBuilder sb = new StringBuilder();
        sb.append("{number of entries=").append(map.size()).append("}\n");
        int i = 0;
        String separator = "\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n";
        for (Object key : map.keySet()) {
            if (i == 0 && !map.isEmpty()) {
                sb.append(separator);
            }
            sb.append("\t[").append(++i).append("] ").append(key.toString()).append("=\n\t\t ").append(map.get(key).toString()).append(separator);
        }
        return sb.toString();
    }

    public static String listToString(List list) {
        StringBuilder sb = new StringBuilder();
        sb.append("{number of entries=").append(list.size()).append("}\n");
        int i = 0;
        for (Object obj : list) {
            sb.append("[").append(++i).append("] ").append(obj.toString());
            if (i == list.size()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String arrayToString(Object[] args) {
        StringBuilder sb = new StringBuilder();
        sb.append("{number of entries=").append(args.length).append("}\n");
        int i = 0;
        for (Object obj : args) {
            if (obj != null) {
                sb.append("[").append(++i).append("] ").append(obj.toString()).append("\n");
                continue;
            }
            sb.append("[").append(++i).append("] ").append("null").append("\n");
        }
        return sb.toString();
    }

    public static boolean isStringInList(String item, List<String> list) {
        Validate.notNull(list, "list can not be null");
        Validate.notEmpty(item, "item can not be null or empty");
        for (String listItem : list) {
            if (!item.equals(listItem)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean isObjectInList(T item, List<T> list) {
        Validate.notNull(list, "list can not be null");
        Validate.notNull(item, "item can not be null");
        for (T listItem : list) {
            if (!item.equals(listItem)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean isObjectInArray(T item, T[] list) {
        Validate.notNull(list, "list can not be null");
        Validate.notNull(item, "item can not be null");
        for (T listItem : list) {
            if (!item.equals(listItem)) continue;
            return true;
        }
        return false;
    }

    public static String getCallerMethodName() {
        try {
            return Thread.currentThread().getStackTrace()[1].getMethodName();
        }
        catch (Exception e) {
            return "n/a";
        }
    }

    public static String getCallerClassName() {
        try {
            return Thread.currentThread().getStackTrace()[1].getClassName();
        }
        catch (Exception e) {
            return "n/a";
        }
    }

    public static String getClassNameFromStackTrace(int depth) {
        try {
            return Thread.currentThread().getStackTrace()[depth].getClassName();
        }
        catch (Exception e) {
            return "n/a";
        }
    }

    public static ArrayList<String> toArrayListFromObjectRay(Object[] objRay) {
        if (objRay == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Object o : objRay) {
            list.add(o.toString());
        }
        return list;
    }

    public static String getTime() {
        Date d = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy_MM_dd.hh_mm_ss_a.zzz");
        return sdf.format(d);
    }

    public static ByteBuffer fileToByteBuffer(String fileName) {
        try {
            int read;
            FileInputStream is = new FileInputStream(fileName);
            byte[] buffer = new byte[4096];
            ByteBuffer bb = new ByteBuffer();
            while ((read = ((InputStream)is).read(buffer)) != -1) {
                bb.append(buffer, 0, read);
            }
            return bb;
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    public static byte[] fileToBytes(String fileName) {
        ByteBuffer retVal = Utils.fileToByteBuffer(fileName);
        return retVal == null ? null : retVal.getBytes();
    }

    public static byte[] fileToBytes(String fileName, Map<String, ByteBuffer> fileCache) {
        ByteBuffer retVal = Utils.fileToByteBuffer(fileName, fileCache);
        return retVal == null ? null : retVal.getBytes();
    }

    public static ByteBuffer fileToByteBuffer(String fileName, Map<String, ByteBuffer> fileCache) {
        try {
            ByteBuffer o = fileCache.get(fileName);
            if (o != null) {
                ByteBuffer bb = o;
                return bb;
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        ByteBuffer bb = new ByteBuffer(Utils.fileToBytes(fileName));
        fileCache.put(fileName, bb);
        return bb;
    }

    public static String getString(Map m, Object key) {
        return m.get(key) == null ? null : m.get(key).toString();
    }

    public static String[] getTokens(String s, String delim) {
        TheStringTokenizer st = new TheStringTokenizer(s, delim);
        return st.getTokens();
    }

    public static void writeToFile(String msg, String file) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(msg.getBytes());
            fos.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void writeToFile(byte[] msg, String file) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(msg);
            fos.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void writeToFile(ByteBuffer msg, String file) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(msg.getBytes());
            fos.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static String concatenateFilePath(String path1, String path2) {
        StringBuilder sb = new StringBuilder();
        sb.append(path1);
        sb.append(System.getProperty("file.separator"));
        sb.append(path2);
        return sb.toString();
    }

    public static boolean isDifferent(Object lhs, Object rhs) {
        if (lhs == null && rhs == null) {
            return false;
        }
        try {
            return !lhs.equals(rhs);
        }
        catch (Exception e) {
            return true;
        }
    }

    public static <Type extends Serializable> Type copyObject(Type copythis) {
        Serializable retval = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(copythis);
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
            retval = (Serializable)ois.readObject();
            baos.close();
            oos.close();
            ois.close();
        }
        catch (Exception e) {
            return null;
        }
        return (Type)retval;
    }

    public static <ClassType> void createInEDT(Class<ClassType> aClass) {
        throw new UnsupportedOperationException();
    }
}

