/*
 * Decompiled with CFR 0.152.
 */
package Task;

import Task.AbstractTask;
import Task.AutoShutdownSignals;
import Task.Manager.TaskManager;
import Task.NetworkTaskHandler;
import Task.NetworkTaskHandlerIF;
import Task.StateChanger;
import Task.TaskException;
import Task.TaskExecutorIF;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import org.swixml.contrib.gmap.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkTask<ReturnValueType>
extends AbstractTask {
    protected boolean testMode_Enabled = false;
    protected boolean testMode_isOnline = false;
    protected NetworkTaskHandlerIF<ReturnValueType> _taskHandler = new NetworkTaskHandler();
    protected TaskExecutorIF<ReturnValueType> _exec;
    protected SwingWorker<ReturnValueType, Void> _swingWorker;

    @Override
    public AbstractTask.Type getType() {
        return AbstractTask.Type.NonRecurringNetworkTask;
    }

    public NetworkTask(TaskManager container, TaskExecutorIF<ReturnValueType> exec, String name, String descr, AutoShutdownSignals ... policy) throws IllegalArgumentException {
        Validate.notNull(exec, "TaskExecutorIF<T> can not be null");
        Validate.notNull(container, "DesktopAppContainerIF can not be null");
        Validate.notEmpty(name, "name can not be empty or null");
        Validate.notEmpty(descr, "descr can not be empty or null");
        this._exec = exec;
        this.setTaskManager(container);
        Validate.notEmpty(name, "TaskRoot name can not be empty or null");
        Validate.notEmpty(descr, "TaskRoot description can not be empty or null");
        this.setName(name);
        this.setDescription(descr);
        this.setAutoShutdownPolicy(policy);
        container.registerTask(this);
    }

    @Override
    public void doShutdown() {
        this.cancel();
        this._taskHandler.shutdownCalled(this);
    }

    NetworkTask(TaskExecutorIF<ReturnValueType> exec) {
        Validate.notNull(exec, "exec can not be null");
        this._exec = exec;
        this.testMode_Enabled = true;
    }

    public void setTestMode_isOnline(boolean flag) {
        this.testMode_isOnline = flag;
    }

    public void setTaskHandler(NetworkTaskHandlerIF<ReturnValueType> handler) throws IllegalArgumentException {
        Validate.notNull(handler, "NetworkTaskHandler can not be null");
        this._taskHandler = handler;
    }

    @Override
    public SwingWorker<ReturnValueType, Void> getSwingWorker() {
        return this._swingWorker;
    }

    @Override
    public void execute() throws TaskException {
        this._assertIsNotShutdown();
        this._assertNoSwingWorkerCurrentlyActive();
        StateChanger.signalBeforeStart(this._taskHandler, this);
        StateChanger.signalStart(this, this._taskHandler, this._exec);
        this._createSwingWorker(null);
        this.getUIHook().setSwingWorker(this._swingWorker);
        this._swingWorker.execute();
    }

    protected void executeAndWait() throws TaskException {
        this._assertIsNotShutdown();
        StateChanger.signalBeforeStart(this._taskHandler, this);
        StateChanger.signalStart(this, this._taskHandler, this._exec);
        ArrayBlockingQueue gate = new ArrayBlockingQueue(1);
        this._createSwingWorker(gate);
        this.getUIHook().setSwingWorker(this._swingWorker);
        this._swingWorker.execute();
        try {
            gate.take();
        }
        catch (InterruptedException e) {
            this.cancel();
        }
    }

    protected void _createSwingWorker(final BlockingQueue gate) {
        this._swingWorker = new SwingWorker<ReturnValueType, Void>(){
            boolean isNotOnline = false;
            long startTime;
            long endTime;

            @Override
            protected ReturnValueType doInBackground() throws Exception {
                this.startTime = System.currentTimeMillis();
                if (NetworkTask.this.testMode_Enabled) {
                    if (NetworkTask.this.testMode_isOnline) {
                        return NetworkTask.this._exec.doInBackground(this, NetworkTask.this.getUIHook());
                    }
                    this.isNotOnline = true;
                    return null;
                }
                if (NetworkTask.this.getTaskManager() != null && NetworkTask.this.getTaskManager().isOnline()) {
                    return NetworkTask.this._exec.doInBackground(this, NetworkTask.this.getUIHook());
                }
                this.isNotOnline = true;
                return null;
            }

            @Override
            protected void done() {
                if (!this.isNotOnline) {
                    try {
                        Object retVal = this.get();
                        this.endTime = System.currentTimeMillis();
                        StateChanger.signalStopped(NetworkTask.this, NetworkTask.this._taskHandler, this.endTime - this.startTime);
                        StateChanger.signalOK(NetworkTask.this, NetworkTask.this._taskHandler, NetworkTask.this._exec, retVal, this.endTime - this.startTime);
                    }
                    catch (ExecutionException ex) {
                        this.endTime = System.currentTimeMillis();
                        StateChanger.signalStopped(NetworkTask.this, NetworkTask.this._taskHandler, this.endTime - this.startTime);
                        StateChanger.signalErr(NetworkTask.this, NetworkTask.this._taskHandler, NetworkTask.this._exec, ex, this.endTime - this.startTime);
                    }
                    catch (InterruptedException ex) {
                        this.endTime = System.currentTimeMillis();
                        StateChanger.signalStopped(NetworkTask.this, NetworkTask.this._taskHandler, this.endTime - this.startTime);
                        StateChanger.signalInterrupted(NetworkTask.this, NetworkTask.this._taskHandler, NetworkTask.this._exec, ex, this.endTime - this.startTime);
                    }
                    catch (CancellationException ex) {
                        this.endTime = System.currentTimeMillis();
                        StateChanger.signalStopped(NetworkTask.this, NetworkTask.this._taskHandler, this.endTime - this.startTime);
                        StateChanger.signalCancelled(NetworkTask.this, NetworkTask.this._taskHandler, NetworkTask.this._exec, this.endTime - this.startTime);
                    }
                } else {
                    this.endTime = System.currentTimeMillis();
                    StateChanger.signalStopped(NetworkTask.this, NetworkTask.this._taskHandler, this.endTime - this.startTime);
                    StateChanger.signalNotOnline(NetworkTask.this, NetworkTask.this._taskHandler, NetworkTask.this._exec);
                }
                NetworkTask.this._openGate(gate);
            }
        };
    }

    protected void _openGate(BlockingQueue gate) {
        if (gate != null) {
            try {
                gate.put("");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

