package org.swixml.contrib;

import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.jdesktop.beansbinding.Converter;
import org.swixml.jsr.widgets.BindableBasicWidget;
import org.swixml.jsr295.BindingUtils;

public class RSyntaxTextAreaEx extends RSyntaxTextArea implements BindableBasicWidget {

    public String getBindWith() {
        return (String) getClientProperty(BINDWITH_PROPERTY);
    }

    public void setBindWith(String bindWith) {
        putClientProperty(BINDWITH_PROPERTY, bindWith);
    }

    public void setConverter(Converter<?, ?> converter) {
        putClientProperty(CONVERTER_PROPERTY, converter);
    }

    public Converter<?, ?> getConverter() {
        return (Converter<?, ?>) getClientProperty(CONVERTER_PROPERTY);
    }

    @Override
    public void addNotify() {

        final String bindWith = getBindWith();

        if( null!=bindWith && !bindWith.isEmpty() ){

            BindingUtils.parseBind( this, "text", bindWith, getConverter() );

        }

        super.addNotify();
    }
}
