/*
 * Decompiled with CFR 0.152.
 */
package org.swixml.contrib;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;
import org.jdesktop.application.Application;
import org.jdesktop.application.SingleFrameApplication;

public class JMenuButton
extends JPanel {
    private JButton button;
    private JButton arrowButton;
    private JPopupMenu popupMenu;
    private List<Action> actions = Collections.emptyList();

    public JMenuButton() {
        this.initGui();
    }

    public JMenuButton(String text, Action[] menuItems) {
        this(text, null, menuItems);
    }

    public JMenuButton(Icon icon, Action[] menuItems) {
        this(null, icon, menuItems);
    }

    public JMenuButton(String text, Icon icon, Action[] menuItems) {
        super.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent ev) {
                JMenuButton.this.button.setEnabled((Boolean)ev.getNewValue());
            }
        });
        if (menuItems != null) {
            this.actions = Arrays.asList(menuItems);
        }
        this.button = text == null && icon != null ? new JButton(icon) : (text != null && icon == null ? new JButton(text) : new JButton(text, icon));
        this.initGui();
    }

    public void addNotify() {
        super.addNotify();
        this.initGui();
    }

    public Component add(Component c) {
        if (c instanceof JPopupMenu) {
            this.popupMenu = (JPopupMenu)c;
            return c;
        }
        return super.add(c);
    }

    public String getText() {
        return this.button.getText();
    }

    public void setText(String text) {
        this.button.setText(text);
    }

    public Icon getIcon() {
        return this.button.getIcon();
    }

    public void setIcon(Icon icon) {
        this.button.setIcon(icon);
    }

    public Icon getDisabledIcon() {
        return this.button.getDisabledIcon();
    }

    public void setDisabledIcon(Icon icon) {
        this.button.setDisabledIcon(icon);
    }

    private void initGui() {
        if (this.button == null) {
            this.button = new JButton("");
        }
        this.button.setBorder(BorderFactory.createEmptyBorder());
        this.button.setOpaque(this.isOpaque());
        this.arrowButton = new JButton(MenuArrowIcon.INSTANCE);
        this.arrowButton.setMargin(new Insets(0, 1, 0, 1));
        this.arrowButton.setBorder(BorderFactory.createEmptyBorder());
        this.arrowButton.setOpaque(this.isOpaque());
        this.arrowButton.setPreferredSize(new Dimension(11, 11));
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.setLayout(new BorderLayout());
        this.add((Component)this.button, "Center");
        this.add((Component)this.arrowButton, "East");
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!JMenuButton.this.actions.isEmpty()) {
                    ((Action)JMenuButton.this.actions.get(0)).actionPerformed(e);
                }
            }
        });
        final JMenuButton me = this;
        this.arrowButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (!JMenuButton.this.isEnabled()) {
                    return;
                }
                Point p = new Point(JMenuButton.this.getLocation());
                SingleFrameApplication app = (SingleFrameApplication)Application.getInstance(SingleFrameApplication.class);
                SwingUtilities.convertPoint(me, p, app.getMainFrame());
                JButton source = JMenuButton.this.arrowButton;
                JMenuButton.this.popupMenu.show(source, p.x + ((Component)source).getWidth(), p.y);
            }
        });
    }

    public void setOpaque(boolean isOpaque) {
        super.setOpaque(isOpaque);
        if (this.button != null) {
            this.button.setOpaque(isOpaque);
        }
        if (this.arrowButton != null) {
            this.arrowButton.setOpaque(isOpaque);
        }
    }

    private static class MenuArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final MenuArrowIcon INSTANCE = new MenuArrowIcon();
        private static final int WIDTH = 4;
        private static final int HEIGHT = 8;

        private MenuArrowIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color origColor = g.getColor();
            g.setColor(c.getForeground());
            int yoffset = c.getHeight() / 2 - 1;
            int xoffset = c.getWidth() / 2 - 2;
            g.drawLine(xoffset, yoffset, xoffset + 5, yoffset);
            g.drawLine(xoffset + 1, yoffset + 1, xoffset + 4, yoffset + 1);
            g.drawLine(xoffset + 2, yoffset + 2, xoffset + 3, yoffset + 2);
            g.setColor(origColor);
        }

        public int getIconWidth() {
            return 4;
        }

        public int getIconHeight() {
            return 8;
        }
    }
}

