/*
 * Decompiled with CFR 0.152.
 */
package Task.Support.GUISupport;

import Task.Support.GUISupport.Colors;
import Task.Support.GUISupport.GUIUtils;
import java.awt.Font;
import java.util.concurrent.ConcurrentHashMap;
import org.swixml.contrib.gmap.Validate;

public class FontUtils {
    public static final ConcurrentHashMap<String, Font> FontCache = new ConcurrentHashMap(20);

    public static void setFonts() {
        GUIUtils.setUIDefaultFontProperty("Button.font", FontStyles.VariableWidthSmall.font());
        GUIUtils.setUIDefaultFontProperty("Label.font", FontStyles.VariableWidthSmall.font());
        GUIUtils.setUIDefaultFontProperty("CheckBox.font", FontStyles.VariableWidthSmall.font());
        GUIUtils.setUIDefaultFontProperty("ProgressBar.font", FontStyles.VariableWidthSmall.font());
        GUIUtils.setUIDefaultFontProperty("TextArea.font", FontStyles.FixedWidthNormal.font());
        GUIUtils.setUIDefaultFontProperty("Table.font", FontStyles.VariableWidthSmall.font());
        GUIUtils.setUIDefaultFontProperty("Tree.font", FontStyles.VariableWidthSmall.font());
        GUIUtils.setUIDefaultFontProperty("TableHeader.font", FontStyles.VariableWidthSmall.font());
        GUIUtils.setUIDefaultFontProperty("List.font", FontStyles.VariableWidthSmall.font());
        GUIUtils.setUIDefaultFontProperty("ComboBox.font", FontStyles.VariableWidthSmall.font());
        GUIUtils.setUIDefaultFontProperty("FormattedTextField.font", FontStyles.VariableWidthSmall.font());
        GUIUtils.setUIDefaultFontProperty("TextField.font", FontStyles.VariableWidthSmall.font());
        GUIUtils.setUIDefaultFontProperty("PasswordField.font", FontStyles.VariableWidthSmall.font());
        GUIUtils.setUIDefaultFontProperty("JideTabbedPane.font", FontStyles.VariableWidthSmall.font());
        GUIUtils.setUIDefaultFontProperty("JideTabbedPane.selectedTabFont", FontStyles.VariableWidthSmall.font());
        GUIUtils.setUIDefaultColorProperty("ProgressBar.foreground", Colors.SmurfBlue.color());
        GUIUtils.setUIDefaultColorProperty("Button.foreground", Colors.LightBlack.color());
        GUIUtils.setUIDefaultColorProperty("Label.foreground", Colors.LightBlack.color());
        GUIUtils.setUIDefaultColorProperty("TextArea.foreground", Colors.LightBlack.color());
        GUIUtils.setUIDefaultColorProperty("TextField.foreground", Colors.LightBlack.color());
        GUIUtils.setUIDefaultColorProperty("PasswordField.foreground", Colors.LightBlack.color());
    }

    public static Font create(String name, int style, float size) throws IllegalArgumentException {
        Font font;
        Validate.notEmpty(name, "name can not be empty or null");
        String key_NAME_STYLE = FontUtils.fontToString(name, style);
        String key_NAME_STYLE_SIZE = FontUtils.fontToString(name, style, size);
        if (FontCache.containsKey(key_NAME_STYLE_SIZE)) {
            font = FontCache.get(key_NAME_STYLE_SIZE);
        } else if (FontCache.containsKey(key_NAME_STYLE)) {
            font = FontCache.get(key_NAME_STYLE).deriveFont(size);
            FontCache.put(key_NAME_STYLE_SIZE, font);
        } else {
            font = new Font(name, style, (int)size);
            FontCache.put(key_NAME_STYLE_SIZE, font);
        }
        return font;
    }

    private static final String fontToString(String name, int style, float size) throws IllegalArgumentException {
        Validate.notEmpty(name, "name can not be empty or null");
        StringBuilder sb = new StringBuilder();
        sb.append(name).append(",").append(style).append(",").append(size);
        return sb.toString();
    }

    private static final String fontToString(String name, int style) throws IllegalArgumentException {
        Validate.notEmpty(name, "name can not be empty or null");
        StringBuilder sb = new StringBuilder();
        sb.append(name).append(",").append(style);
        return sb.toString();
    }

    public static String dumpFontCache() {
        StringBuilder sb = new StringBuilder();
        sb.append("FontUtils.FontCache:\n");
        for (String key : FontCache.keySet()) {
            sb.append("key=[").append(key).append("], ").append("font=[").append(FontCache.get(key).getName()).append("]\n");
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FontNames {
        LucidaGrande("Lucida Grande"),
        Consolas("Consolas"),
        SegoeUI("Segoe UI"),
        Calibri("Calibri");

        public String _name;

        private FontNames(String name) {
            this._name = name;
        }

        public String getName() {
            return this.toString();
        }

        public String toString() {
            return this._name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FontStyles {
        FixedWidthXSmall(FontNames.Consolas, 0, 9.0f),
        FixedWidthSmall(FontNames.Consolas, 0, 11.0f),
        FixedWidthNormal(FontNames.Consolas, 0, 13.0f),
        FixedWidthLarge(FontNames.Consolas, 0, 18.0f),
        VariableWidthXXSmall(FontNames.SegoeUI, 0, 8.0f),
        VariableWidthXSmall(FontNames.SegoeUI, 0, 9.0f),
        VariableWidthSmall(FontNames.SegoeUI, 0, 13.0f),
        VariableWidthNormal(FontNames.SegoeUI, 0, 14.0f),
        VariableWidthLarge(FontNames.LucidaGrande, 0, 16.0f),
        VariableWidthXLarge(FontNames.LucidaGrande, 1, 18.0f),
        VariableWidthXXLarge(FontNames.LucidaGrande, 1, 24.0f);

        FontNames _face;
        int _style;
        float _size;

        private FontStyles(FontNames face, int style, float size) throws IllegalArgumentException {
            Validate.notNull((Object)face, "face can not be empty or null");
            this._face = face;
            this._style = style;
            this._size = size;
        }

        public Font font() {
            Font f = FontUtils.create(this._face.getName(), this._style, this._size);
            return f;
        }

        public Font font(int style) {
            Font f = FontUtils.create(this._face.getName(), style, this._size);
            return f;
        }

        public Font font(float size) {
            Font f = FontUtils.create(this._face.getName(), this._style, size);
            return f;
        }

        public String toString() {
            return FontUtils.fontToString(this._face.getName(), this._style, this._size);
        }
    }
}

