/*
 * Decompiled with CFR 0.152.
 */
package Task.Support.GUISupport;

import Task.Support.GUISupport.Colors;
import Task.Support.GUISupport.GradientPainter;
import Task.Support.GUISupport.ImageUtils;
import com.sun.java.swing.Painter;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import org.jdesktop.swingx.graphics.ReflectionRenderer;
import org.jdesktop.swingx.painter.AbstractAreaPainter;
import org.jdesktop.swingx.painter.AbstractLayoutPainter;
import org.jdesktop.swingx.painter.GlossPainter;
import org.jdesktop.swingx.painter.ImagePainter;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.painter.PinstripePainter;
import org.jdesktop.swingx.painter.RectanglePainter;
import org.swixml.contrib.gmap.Validate;

public class DrawingUtils {
    private static Logger LOG = Logger.getLogger(DrawingUtils.class.getName());
    private static Painter DISABLED_GLASS_PANE_BG_PAINTER;
    public static Color[] WHITE_2GRAD;
    public static Color[] GRAY_4GRAD;
    public static Color[] REV_GRAY_4GRAD;

    public static final Rectangle2D getTextBounds(Graphics2D g2, Font font, String str) throws IllegalArgumentException {
        Validate.notNull(g2, "g2 can not be null");
        Validate.notNull(font, "font can not be null");
        Validate.notNull(str, "str can not be null");
        FontMetrics fm = g2.getFontMetrics(font);
        return fm.getStringBounds(str, g2);
    }

    public static Graphics2D applyDesktopAASettings(Graphics2D g) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Map map = (Map)tk.getDesktopProperty("awt.font.desktophints");
        if (map != null) {
            g.addRenderingHints(map);
        }
        return g;
    }

    public static Graphics2D applySmoothDrawingSettings(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        return g;
    }

    public static Border getLightBorder() {
        return BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(0, Colors.LightFrost.alpha(0.1f), Colors.DarkFrost.alpha(0.1f)), BorderFactory.createEmptyBorder(1, 1, 1, 1));
    }

    public static Border getDarkBorder() {
        return BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(0, Colors.LightFrost.alpha(0.3f), Colors.DarkFrost.alpha(0.3f)), BorderFactory.createEmptyBorder(1, 1, 1, 1));
    }

    public static BufferedImage getReflection(BufferedImage img, float length, float opacity, boolean blur) {
        ReflectionRenderer renderer = new ReflectionRenderer();
        renderer.setOpacity(opacity);
        renderer.setLength(length);
        renderer.setBlurEnabled(blur);
        BufferedImage reflection = renderer.appendReflection(img);
        return reflection;
    }

    public static BufferedImage getGlossyImage(BufferedImage image) {
        return DrawingUtils.getGlossyImage(image, new Color(1.0f, 1.0f, 1.0f, 0.2f), GlossPainter.GlossPosition.TOP);
    }

    public static BufferedImage getGlossyImage(BufferedImage image, Color color, GlossPainter.GlossPosition position) {
        Color paint = color;
        int width = image.getWidth();
        int height = image.getHeight();
        Graphics2D g2 = ImageUtils.g2(image);
        Ellipse2D.Double ellipse = new Ellipse2D.Double((double)(-width) / 2.0, (double)height / 2.7, (double)width * 2.0, (double)height * 2.0);
        Area gloss = new Area(ellipse);
        if (position == GlossPainter.GlossPosition.TOP) {
            Area area = new Area(new Rectangle(0, 0, width, height));
            area.subtract(new Area(ellipse));
            gloss = area;
        }
        g2.setPaint(paint);
        g2.fill(gloss);
        g2.dispose();
        return image;
    }

    public static RectanglePainter getRoundedRectanglePainter(Color fillColor, Color borderColor, int borderWidth, AbstractAreaPainter.Style style, int roundedWidth) {
        RectanglePainter _rectPainter = new RectanglePainter((Paint)fillColor, (Paint)borderColor, (float)borderWidth, style);
        _rectPainter.setRounded(true);
        _rectPainter.setRoundWidth(roundedWidth);
        _rectPainter.setRoundHeight(roundedWidth);
        return _rectPainter;
    }

    public static Painter getDropTargetLabelBgPainter() {
        GradientPainter gradientPainter = new GradientPainter(Colors.White.alpha(0.3f), Colors.LightGray.alpha(0.1f), true);
        return gradientPainter;
    }

    public static Painter getPanelBgPainter() {
        GradientPainter gradientPainter = new GradientPainter(Colors.LightGray.alpha(0.3f), Colors.LightGray.alpha(0.7f), false);
        return gradientPainter;
    }

    public static Painter getStatusUpdaterBgPainter() {
        throw new UnsupportedOperationException();
    }

    public static Painter getInfoLabelBgPainter() {
        throw new UnsupportedOperationException();
    }

    public static Painter getContentPanelBgPainter() {
        GradientPainter gp = new GradientPainter(Colors.LightGray.alpha(0.3f), Colors.Gray.alpha(0.3f), true);
        return gp;
    }

    public static Painter getHeaderPanelBgPainter() {
        throw new UnsupportedOperationException();
    }

    public static Painter getGradientFillBgPainter(int width, int height, Color color1, Color color2) {
        LinearGradientPaint gradientPaint = new LinearGradientPaint(0.0f, 0.0f, width, height, new float[]{0.0f, 1.0f}, new Color[]{color1, color2});
        MattePainter mattePainter = new MattePainter((Paint)gradientPaint);
        return (Painter)mattePainter;
    }

    public static Painter getDisabledGlassPaneBgPainter(int width, int height) {
        if (DISABLED_GLASS_PANE_BG_PAINTER == null) {
            ImagePainter imgPainter = null;
            try {
                BufferedImage img = ImageUtils.loadBufferedImage("images/splashscreen.png", true, 0.05f);
                int imgW = img.getWidth();
                int imgH = img.getHeight();
                BufferedImage scaledImg = ImageUtils.getScaledBufferedImage(img, (int)((double)imgW * 0.8), (int)((double)imgH * 0.8));
                ReflectionRenderer renderer = new ReflectionRenderer();
                renderer.setOpacity(0.8f);
                renderer.setLength(1.0f);
                renderer.setBlurEnabled(true);
                BufferedImage reflection = renderer.appendReflection(scaledImg);
                imgPainter = new ImagePainter(reflection, AbstractLayoutPainter.HorizontalAlignment.CENTER, AbstractLayoutPainter.VerticalAlignment.CENTER);
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "splashscreen.png was not found in the classpath. Could not paint a translucent background image", e);
            }
            PinstripePainter pinstripePainter = new PinstripePainter((Paint)Colors.LightFrost.alpha(0.3f), 45.0);
            GradientPainter gp = new GradientPainter(width, height, Colors.Black.alpha(0.3f), Colors.MediumGray.alpha(0.3f), true);
            throw new UnsupportedOperationException();
        }
        return DISABLED_GLASS_PANE_BG_PAINTER;
    }

    public static BufferedImage getBlurredImage(BufferedImage buf) {
        float[] my_kernel = new float[]{0.1f, 0.1f, 0.1f, 0.1f, 0.2f, 0.1f, 0.1f, 0.1f, 0.1f};
        ConvolveOp op = new ConvolveOp(new Kernel(3, 3, my_kernel));
        return op.filter(buf, null);
    }

    public static BufferedImage getTranslucentImage(BufferedImage buf, float translucency) {
        BufferedImage bufNew = ImageUtils.createCompatibleImage(buf.getWidth(), buf.getHeight(), false);
        Graphics2D g2 = ImageUtils.g2(bufNew);
        AlphaComposite c = AlphaComposite.SrcOver.derive(translucency);
        g2.setComposite(c);
        g2.drawImage((Image)buf, 0, 0, null);
        g2.dispose();
        return bufNew;
    }

    public static void drawBorderedTranslucentImage(Graphics g, int width, int height, boolean enabled, Color[] fourGradientTheme) {
        Graphics2D g2 = ImageUtils.g2(g);
        LinearGradientPaint p = new LinearGradientPaint(0.0f, 0.0f, 0.0f, height, new float[]{0.0f, 0.499f, 0.5f, 1.0f}, fourGradientTheme);
        AlphaComposite c = AlphaComposite.SrcOver.derive(0.2f);
        g2.setComposite(c);
        g2.setPaint(p);
        int offset = 2;
        RoundRectangle2D.Float round = new RoundRectangle2D.Float(offset, offset, width - offset * 2, height - offset * 2, 10.0f, 10.0f);
        g2.fill(round);
        if (enabled) {
            g2.setColor(Color.black);
        } else {
            g2.setColor(Color.gray);
        }
        g2.setStroke(new BasicStroke(offset));
        g2.draw(round);
        g2.dispose();
    }

    public static void drawSemiTransparentShade(Graphics g, int width, int height, Color[] twoGradientTheme) {
        Graphics2D g2 = ImageUtils.g2(g);
        AlphaComposite c = AlphaComposite.SrcOver.derive(0.3f);
        g2.setComposite(c);
        LinearGradientPaint p = new LinearGradientPaint(0.0f, 0.0f, 0.0f, height, new float[]{0.0f, 1.0f}, twoGradientTheme);
        g2.setPaint(p);
        int offset = 2;
        RoundRectangle2D.Float round = new RoundRectangle2D.Float(offset, offset, width - offset * 2, height - offset * 2, 10.0f, 10.0f);
        g2.fill(round);
        g2.dispose();
    }

    public static void drawShadeNormal(Graphics g, int width, int height, Color[] twoGradientTheme, float alpha) {
        Graphics2D g2 = ImageUtils.g2(g);
        AlphaComposite c = AlphaComposite.SrcOver.derive(alpha);
        g2.setComposite(c);
        LinearGradientPaint p = new LinearGradientPaint(0.0f, 0.0f, 0.0f, height, new float[]{0.0f, 1.0f}, twoGradientTheme);
        g2.setPaint(p);
        Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, 0.0f, width, height);
        g2.fill(rect);
        g2.dispose();
    }

    public static void drawShadeFast(Graphics g, int width, int height, Color[] twoGradientTheme, float alpha) {
        throw new UnsupportedOperationException();
    }

    public static void drawShade4Stops(Graphics g, int width, int height, Color[] fourGradientTheme, float alpha) {
        Graphics2D g2 = ImageUtils.g2(g);
        AlphaComposite c = AlphaComposite.SrcOver.derive(alpha);
        g2.setComposite(c);
        LinearGradientPaint p = new LinearGradientPaint(0.0f, 0.0f, 0.0f, height, new float[]{0.0f, 0.49f, 0.5f, 1.0f}, fourGradientTheme);
        g2.setPaint(p);
        Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, 0.0f, width, height);
        g2.fill(rect);
        g2.dispose();
    }

    static {
        WHITE_2GRAD = new Color[]{Color.LIGHT_GRAY, Color.WHITE};
        GRAY_4GRAD = new Color[]{Color.WHITE, Color.GRAY, Color.BLACK, Color.DARK_GRAY};
        REV_GRAY_4GRAD = new Color[]{Color.DARK_GRAY, Color.BLACK, Color.GRAY, Color.WHITE};
    }
}

