/*
 * Decompiled with CFR 0.152.
 */
package Task.Support.CoreSupport;

import Task.Support.CoreSupport.ByteBuffer;
import Task.Support.CoreSupport.Utils;
import Task.Support.CoreSupport.ZipObjectException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.swixml.contrib.gmap.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipObject<T extends Serializable>
implements Serializable {
    static final long serialVersionUID = 5572357487744011409L;
    protected byte[] buffer;

    public String toString() {
        if (this.buffer != null) {
            return (float)this.buffer.length / 1000.0f + " KB";
        }
        return "0 KB";
    }

    public byte[] toBytes() throws ZipObjectException {
        if (this.buffer == null) {
            throw new ZipObjectException("the internal byte array is null");
        }
        return this.buffer;
    }

    public InputStream toInputStream() throws ZipObjectException {
        if (this.buffer == null) {
            throw new ZipObjectException("the internal byte array is null");
        }
        return new ByteArrayInputStream(this.buffer);
    }

    public int getSize() {
        return this.buffer == null ? 0 : this.buffer.length;
    }

    public String getSizeString() {
        return Integer.toString(this.getSize());
    }

    public ZipObject(T obj) throws ZipObjectException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gzos = new GZIPOutputStream(baos);
            ObjectOutputStream oos = new ObjectOutputStream(gzos);
            oos.writeObject(obj);
            oos.flush();
            gzos.finish();
            oos.close();
            gzos.close();
            this.buffer = baos.toByteArray();
            baos.close();
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
            throw new ZipObjectException("could not zip given object into a ZipObject");
        }
    }

    public static ZipObject fromBytes(byte[] bytes) throws IllegalArgumentException {
        Validate.notNull(bytes, "bytes can not be null");
        ZipObject zobj = new ZipObject();
        zobj.buffer = bytes;
        return zobj;
    }

    public static ZipObject fromInputStream(InputStream is) throws IOException, IllegalArgumentException {
        Validate.notNull(is, "is can not be null");
        ByteBuffer bb = new ByteBuffer(is);
        return ZipObject.fromBytes(bb.getBytes());
    }

    private ZipObject() {
    }

    public final T getObject() throws ZipObjectException {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.buffer);
            GZIPInputStream gzis = new GZIPInputStream(bais);
            ObjectInputStream ois = new ObjectInputStream(gzis);
            Object obj = ois.readObject();
            bais.close();
            gzis.close();
            ois.close();
            return (T)((Serializable)obj);
        }
        catch (Exception e) {
            throw new ZipObjectException("could not unzip ZipObject to get object");
        }
    }

    public static void main(String[] args) {
        Vector v = new Vector();
        for (int j = 0; j < 100; ++j) {
            Hashtable<Integer, String> ht = new Hashtable<Integer, String>();
            for (int i = 0; i < 10; ++i) {
                ht.put(i, "whatever");
            }
            v.addElement(ht);
        }
        try {
            File tempFile1 = File.createTempFile("uncompressed", "ser");
            File tempFile2 = File.createTempFile("compressed", "ser");
            tempFile1.deleteOnExit();
            tempFile2.deleteOnExit();
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(tempFile1));
            oos.writeObject(v);
            oos.flush();
            oos.close();
            ZipObject vZip = new ZipObject(v);
            oos = new ObjectOutputStream(new FileOutputStream(tempFile2));
            oos.writeObject(vZip);
            oos.flush();
            oos.close();
            System.out.println("Uncompressed file size=" + tempFile1.length());
            System.out.println("Compressed file size=" + tempFile2.length());
            Vector<String> v2 = new Vector<String>();
            v2.addElement("one");
            v2.addElement("two");
            v2.addElement("three");
            v2.addElement("four");
            ZipObject v2Zip = new ZipObject(v2);
            Vector unzipV = v2Zip.getObject();
            System.out.println(Utils.listToString(unzipV));
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

