/*
 * Decompiled with CFR 0.152.
 */
package Task.Support.CoreSupport;

import java.util.ArrayList;

public class TheStringTokenizer {
    protected String s;
    protected String delim;

    public TheStringTokenizer(String s, String delim) {
        this.s = s;
        this.delim = delim;
    }

    public String[] getTokens() {
        Tokenizer t = new Tokenizer();
        t.set(this.s, this.delim);
        String[] strRay = t.getTokens();
        if (t.hasRemainder()) {
            String[] strRay2 = new String[strRay.length + 1];
            System.arraycopy(strRay, 0, strRay2, 0, strRay.length);
            strRay2[strRay2.length - 1] = new String(t.getRemainderOfInput());
            return strRay2;
        }
        return strRay;
    }

    public class Tokenizer {
        protected String input = null;
        protected String delim = null;
        protected String remainder = null;

        public Tokenizer set(String input, String delim) {
            this.input = input;
            this.delim = delim;
            this.remainder = null;
            return this;
        }

        public Tokenizer set(StringBuffer sb, String delim) {
            return this.set(new String(sb), delim);
        }

        public boolean hasTokens() {
            return this.input.indexOf(this.delim) != -1;
        }

        public String[] getTokens() {
            if (this.input == null || this.delim == null) {
                return null;
            }
            if (this.input.indexOf(this.delim) == -1) {
                return null;
            }
            ArrayList<String> list = new ArrayList<String>();
            int markStart = 0;
            int markEnd = 0;
            while ((markEnd = this.input.indexOf(this.delim, markStart)) != -1) {
                list.add(this.input.substring(markStart, markEnd));
                markStart = markEnd + this.delim.length();
            }
            this.remainder = markStart != this.input.length() ? this.input.substring(markStart, this.input.length()) : null;
            String[] strRay = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                strRay[i] = (String)list.get(i);
            }
            return strRay;
        }

        public boolean hasRemainder() {
            return this.remainder != null;
        }

        public StringBuffer getRemainderOfInput() {
            return this.remainder != null ? new StringBuffer(this.remainder) : new StringBuffer();
        }
    }
}

