/*
 * Decompiled with CFR 0.152.
 */
package Task.Support.CoreSupport;

import Task.Support.CoreSupport.ConstantsIF;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class ByteBuffer
implements ConstantsIF,
Serializable {
    static final long serialVersionUID = 7401588019652180668L;
    public static final int BUFFER_SIZE = 4096;
    protected byte[] byteRay = null;
    protected String enc = "US-ASCII";

    public ByteBuffer() {
    }

    public ByteBuffer(byte[] srcBuf) {
        this.append(srcBuf);
    }

    public ByteBuffer(ByteBuffer bb) {
        this.append(bb);
    }

    public ByteBuffer(InputStream is) throws IOException {
        int read;
        byte[] readBuf = new byte[4096];
        while ((read = is.read(readBuf)) != -1) {
            this.append(readBuf, 0, read);
        }
    }

    public ByteBuffer append(byte[] srcBuf, int srcStartIndex, int srcLength) {
        if (this.byteRay == null) {
            this.byteRay = new byte[srcLength];
            this.arrayCopy(srcBuf, srcStartIndex, this.byteRay, 0, srcLength);
        } else {
            int currentSize = this.byteRay.length;
            byte[] newByteRay = new byte[currentSize + srcLength];
            this.arrayCopy(this.byteRay, 0, newByteRay, 0, currentSize);
            int newByteRayStartIndex = currentSize;
            this.arrayCopy(srcBuf, srcStartIndex, newByteRay, newByteRayStartIndex, srcLength);
            this.byteRay = newByteRay;
        }
        return this;
    }

    public byte[] toByteArray() {
        return this.getBytes();
    }

    public String toString() {
        if (this.byteRay != null && this.byteRay.length > 0) {
            float sizeInKB = (float)this.byteRay.length / 1000.0f;
            return sizeInKB + " KB";
        }
        return "0 KB";
    }

    public void setEncoding(String enc) {
        if (enc == null) {
            return;
        }
        try {
            byte[] bytes = new byte[]{48, 49};
            new String(bytes, enc);
            this.enc = enc;
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("unsupported encoding");
        }
    }

    protected final void arrayCopy(byte[] srcBuf, int srcStartIndex, byte[] destBuf, int destStartIndex, int numberOfBytesToCopy) {
        System.arraycopy(srcBuf, srcStartIndex, destBuf, destStartIndex, numberOfBytesToCopy);
    }

    public byte[] getBytes() {
        if (this.byteRay == null) {
            return new byte[0];
        }
        return this.byteRay;
    }

    public ByteArrayInputStream getInputStream() {
        return new ByteArrayInputStream(this.getBytes());
    }

    public int getSize() {
        if (this.byteRay != null) {
            return this.byteRay.length;
        }
        return 0;
    }

    public void append(byte[] srcBuf) {
        this.append(srcBuf, 0, srcBuf.length);
    }

    public void append(ByteBuffer buf) {
        this.append(buf.getBytes(), 0, buf.getSize());
    }

    public void clear() {
        if (this.byteRay != null) {
            this.byteRay = null;
        }
    }

    public static void main(String[] args) {
        byte[] br1 = new byte[]{48, 49};
        byte[] br2 = new byte[]{60, 84, 62};
        System.out.println("::bb1.append( br1 )");
        ByteBuffer bb1 = new ByteBuffer().append(br1, 0, 2);
        bb1.setEncoding("UTF-8");
        System.out.println();
        System.out.println("::bb1.toString():" + bb1.toString());
        System.out.println();
        System.out.println("::bb1.append( br2 )");
        bb1.append(br2, 0, 3);
        System.out.println();
        System.out.println("::bb1.toString():" + bb1.toString());
        System.out.println();
    }
}

