/*
 * Decompiled with CFR 0.152.
 */
package Task;

import Task.AbstractTask;
import Task.NetworkTaskHandlerIF;
import Task.SimpleTaskHandlerIF;
import Task.TaskExecutorIF;
import java.util.concurrent.ExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateChanger {
    public static void signalInterrupted(AbstractTask task, SimpleTaskHandlerIF taskHandler, TaskExecutorIF exec, InterruptedException ex, long time) {
        task.setState(AbstractTask.State.Interrupted);
        taskHandler.interrupted(ex, task);
        task.setStatus(StateChanger.appendRetryMessage(exec.getInterruptedMessage(), exec));
    }

    public static void signalErr(AbstractTask task, SimpleTaskHandlerIF taskHandler, TaskExecutorIF exec, ExecutionException ex, long time) {
        task.setState(AbstractTask.State.Err);
        taskHandler.error(ex.getCause(), time, task);
        task.setStatus(StateChanger.appendRetryMessage(ex.getCause().getMessage(), exec));
    }

    public static void signalBeforeStart(SimpleTaskHandlerIF taskHandler, AbstractTask task) {
        taskHandler.beforeStart(task);
    }

    public static <T> void signalOK(AbstractTask task, SimpleTaskHandlerIF<T> taskHandler, TaskExecutorIF<T> exec, T retVal, long time) {
        task.setState(AbstractTask.State.OK);
        taskHandler.ok(retVal, time, task);
        task.setStatus(exec.getSuccessMessage());
    }

    public static void signalStart(AbstractTask task, SimpleTaskHandlerIF taskHandler, TaskExecutorIF exec) {
        task.setState(AbstractTask.State.Started);
        taskHandler.started(task);
        task.setStatus(exec.getStartMessage());
    }

    public static void signalStopped(AbstractTask task, SimpleTaskHandlerIF taskHandler, long time) {
        task.setState(AbstractTask.State.Stopped);
        taskHandler.stopped(time, task);
    }

    public static void signalCancelled(AbstractTask task, SimpleTaskHandlerIF taskHandler, TaskExecutorIF exec, long time) {
        task.setState(AbstractTask.State.Cancelled);
        taskHandler.cancelled(time, task);
        task.setStatus(exec.getCancelledMessage());
    }

    public static void signalNotOnline(AbstractTask task, NetworkTaskHandlerIF taskHandler, TaskExecutorIF exec) {
        task.setState(AbstractTask.State.NotOnline);
        taskHandler.notOnline(task);
        task.setStatus(StateChanger.appendRetryMessage(exec.getNotOnlineMessage(), exec));
    }

    private static String appendRetryMessage(String msg, TaskExecutorIF exec) {
        msg = msg + " " + exec.getRetryMessage();
        return msg;
    }
}

