/*
 * Decompiled with CFR 0.152.
 */
package Task;

import Task.AbstractTask;
import Task.AutoShutdownSignals;
import Task.Manager.TaskManager;
import Task.SimpleTaskHandler;
import Task.SimpleTaskHandlerIF;
import Task.StateChanger;
import Task.TaskException;
import Task.TaskExecutorIF;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import org.swixml.contrib.gmap.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTask<ReturnValueType>
extends AbstractTask {
    SimpleTaskHandlerIF<ReturnValueType> _taskHandler = new SimpleTaskHandler();
    protected TaskExecutorIF<ReturnValueType> _exec;
    protected SwingWorker<ReturnValueType, Void> _swingWorker;

    @Override
    public AbstractTask.Type getType() {
        return AbstractTask.Type.NonRecurringTask;
    }

    public SimpleTask(TaskManager taskManager, TaskExecutorIF<ReturnValueType> exec, String name, String descr, AutoShutdownSignals ... autoShutdownPolicy) throws IllegalArgumentException {
        Validate.notNull(exec, "TaskExector<T> can not be null");
        Validate.notEmpty(name, "TaskRoot name can not be empty or null");
        Validate.notEmpty(descr, "TaskRoot description can not be empty or null");
        Validate.notNull(taskManager, "DesktopAppContainerIF can not be null");
        Validate.notNull(autoShutdownPolicy, "AutoStop can not be null");
        this.setTaskManager(taskManager);
        this._exec = exec;
        this.setName(name);
        this.setDescription(descr);
        this.setAutoShutdownPolicy(autoShutdownPolicy);
        taskManager.registerTask(this);
    }

    @Override
    public void doShutdown() {
        this.cancel();
        this._taskHandler.shutdownCalled(this);
    }

    SimpleTask(TaskExecutorIF<ReturnValueType> exec) {
        Validate.notNull(exec, "exec can not be null");
        this._exec = exec;
    }

    public void setTaskHandler(SimpleTaskHandlerIF<ReturnValueType> handler) throws IllegalArgumentException {
        Validate.notNull(handler, "SimpleTaskHandler can not be null");
        this._taskHandler = handler;
    }

    @Override
    public SwingWorker<ReturnValueType, Void> getSwingWorker() {
        return this._swingWorker;
    }

    @Override
    public void execute() throws TaskException {
        this._assertIsNotShutdown();
        this._assertNoSwingWorkerCurrentlyActive();
        StateChanger.signalBeforeStart(this._taskHandler, this);
        StateChanger.signalStart(this, this._taskHandler, this._exec);
        this._createSwingWorker();
        this.getUIHook().setSwingWorker(this._swingWorker);
        this._swingWorker.execute();
    }

    protected void _createSwingWorker() {
        this._swingWorker = new SwingWorker<ReturnValueType, Void>(){
            long startTime;
            long endTime;

            @Override
            protected ReturnValueType doInBackground() throws Exception {
                this.startTime = System.currentTimeMillis();
                return SimpleTask.this._exec.doInBackground(this, SimpleTask.this.getUIHook());
            }

            @Override
            protected void done() {
                try {
                    Object retVal = this.get();
                    this.endTime = System.currentTimeMillis();
                    StateChanger.signalStopped(SimpleTask.this, SimpleTask.this._taskHandler, this.endTime - this.startTime);
                    StateChanger.signalOK(SimpleTask.this, SimpleTask.this._taskHandler, SimpleTask.this._exec, retVal, this.endTime - this.startTime);
                }
                catch (ExecutionException ex) {
                    this.endTime = System.currentTimeMillis();
                    StateChanger.signalStopped(SimpleTask.this, SimpleTask.this._taskHandler, this.endTime - this.startTime);
                    StateChanger.signalErr(SimpleTask.this, SimpleTask.this._taskHandler, SimpleTask.this._exec, ex, this.endTime - this.startTime);
                }
                catch (InterruptedException ex) {
                    this.endTime = System.currentTimeMillis();
                    StateChanger.signalStopped(SimpleTask.this, SimpleTask.this._taskHandler, this.endTime - this.startTime);
                    StateChanger.signalInterrupted(SimpleTask.this, SimpleTask.this._taskHandler, SimpleTask.this._exec, ex, this.endTime - this.startTime);
                }
                catch (CancellationException ex) {
                    this.endTime = System.currentTimeMillis();
                    StateChanger.signalStopped(SimpleTask.this, SimpleTask.this._taskHandler, this.endTime - this.startTime);
                    StateChanger.signalCancelled(SimpleTask.this, SimpleTask.this._taskHandler, SimpleTask.this._exec, this.endTime - this.startTime);
                }
            }
        };
    }
}

