/*
 * Decompiled with CFR 0.152.
 */
package Task.ProgressMonitor;

import Task.ProgressMonitor.ProgressMonitorUtils;
import Task.ProgressMonitor.UIHookAdapter;
import Task.ProgressMonitor.UIHookIF;
import Task.Support.CoreSupport.BitRegister;
import Task.Support.GUISupport.ThreadUtils;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Vector;
import java.util.concurrent.Future;
import org.swixml.contrib.gmap.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingUIHookAdapter
extends UIHookAdapter {
    private Future<?> _swingWorker;
    private boolean _fireSENDStatusUpdates = true;
    private boolean _fireRECIEVEStatusUpdates = true;
    private boolean _savedfireSENDStatusUpdatesFlag = true;
    private boolean _savedfireRECIEVEStatusUpdatesFlag = true;
    protected PropertyChangeSupport _boundProperties = new PropertyChangeSupport(this);

    public SwingUIHookAdapter() {
        this._uiHook = new UIHookIFImpl();
    }

    public SwingUIHookAdapter(Future<?> future) throws IllegalArgumentException {
        this();
        Validate.notNull(future, "SwingWorker can not be null");
        this._swingWorker = future;
    }

    public void clearAllStatusListeners() {
        for (PropertyChangeListener listener : this._boundProperties.getPropertyChangeListeners()) {
            this._boundProperties.removePropertyChangeListener(listener);
        }
    }

    public void addSendStatusListener(PropertyChangeListener l) throws IllegalArgumentException {
        Validate.notNull(l, "PropertyChangeListener can not be null");
        this._boundProperties.addPropertyChangeListener(PropertyList.Send.toString(), l);
    }

    public void addRecieveStatusListener(PropertyChangeListener l) throws IllegalArgumentException {
        Validate.notNull(l, "PropertyChangeListener can not be null");
        this._boundProperties.addPropertyChangeListener(PropertyList.Recieve.toString(), l);
    }

    public void addUnderlyingIOStreamInterruptedOrClosed(PropertyChangeListener l) throws IllegalArgumentException {
        Validate.notNull(l, "PropertyChangeListener can not be null");
        this._boundProperties.addPropertyChangeListener(PropertyList.UnderlyingIOStreamClosed.toString(), l);
        this._boundProperties.addPropertyChangeListener(PropertyList.UnderlyingIOStreamInterruped.toString(), l);
    }

    public void updateSendStatusInUI(int progress, int total) {
        this._boundProperties.firePropertyChange(PropertyList.Send.toString(), Integer.toString(ProgressMonitorUtils.getProgressPercent(progress, total)), ProgressMonitorUtils.generateProgressMessage(ProgressMonitorUtils.Type.Send, this.getProgressMessage(), progress, total));
    }

    public void updateRecieveStatusInUI(int progress, int total) {
        this._boundProperties.firePropertyChange(PropertyList.Recieve.toString(), Integer.toString(ProgressMonitorUtils.getProgressPercent(progress, total)), ProgressMonitorUtils.generateProgressMessage(ProgressMonitorUtils.Type.Recieve, this.getProgressMessage(), progress, total));
    }

    public void closeInUI() {
        this._boundProperties.firePropertyChange(PropertyList.UnderlyingIOStreamClosed.toString(), null, null);
    }

    public void interruptedIOInUI() {
        this._boundProperties.firePropertyChange(PropertyList.UnderlyingIOStreamInterruped.toString(), null, null);
    }

    public void enableSendStatusNotification(boolean enabled) {
        this._fireSENDStatusUpdates = enabled;
    }

    public void enableRecieveStatusNotification(boolean enabled) {
        this._fireRECIEVEStatusUpdates = enabled;
    }

    public void saveNotificationSet() {
        this._savedfireRECIEVEStatusUpdatesFlag = this._fireRECIEVEStatusUpdates;
        this._savedfireSENDStatusUpdatesFlag = this._fireSENDStatusUpdates;
    }

    public void restoreNotificationSet() {
        this._fireRECIEVEStatusUpdates = this._savedfireRECIEVEStatusUpdatesFlag;
        this._fireSENDStatusUpdates = this._savedfireSENDStatusUpdatesFlag;
    }

    public boolean isSendStatusNotificationEnabled() {
        return this._fireSENDStatusUpdates;
    }

    public boolean isRecieveStatusNotificationEnabled() {
        return this._fireRECIEVEStatusUpdates;
    }

    public Future<?> getSwingWorker() {
        return this._swingWorker;
    }

    public void setSwingWorker(Future<?> future) {
        this._swingWorker = future;
    }

    public void cancel() {
        this._uiHook.cancel();
    }

    public boolean isCancelled() {
        return this._uiHook.isCancelled();
    }

    public void resetCancelFlag() {
        this._uiHook.resetCancelFlag();
    }

    public void setProgressMessage(String msg) {
        this._uiHook.setProgressMessage(msg);
    }

    public String getProgressMessage() {
        return this._uiHook.getProgressMessage();
    }

    class UIHookIFImpl
    implements UIHookIF {
        private BitRegister cancelFlag = new BitRegister(false);
        private String progressMessage;
        private UpdateInfo _lastUpdateFired = new UpdateInfo();
        private UpdateInfo _currentUpdate = new UpdateInfo();
        private Runner _runner = new Runner();

        UIHookIFImpl() {
        }

        public void setProgressMessage(String msg) {
            this.progressMessage = msg;
        }

        public String getProgressMessage() {
            return this.progressMessage;
        }

        public void updateSendStatus(int progress, int total) {
            if (SwingUIHookAdapter.this.isSendStatusNotificationEnabled()) {
                this._fireUpdate(PropertyList.Send, progress, total);
            }
        }

        public void updateRecieveStatus(int progress, int total) {
            if (SwingUIHookAdapter.this.isRecieveStatusNotificationEnabled()) {
                this._fireUpdate(PropertyList.Recieve, progress, total);
            }
        }

        private final void _fireUpdate(PropertyList type, int progress, int total) {
            this._currentUpdate.set(type, progress, total);
            if (!this._currentUpdate.hasChanged(this._lastUpdateFired)) {
                return;
            }
            this._lastUpdateFired.copyFrom(this._currentUpdate);
            ThreadUtils.executeLaterInEDT(this._runner.display(type, progress, total));
        }

        public void resetCancelFlag() {
            this.cancelFlag.clear();
        }

        public void cancel() {
            this.cancelFlag.set();
        }

        public boolean isCancelled() {
            if (SwingUIHookAdapter.this.getSwingWorker() == null) {
                return this.cancelFlag.isSet();
            }
            return SwingUIHookAdapter.this.getSwingWorker().isCancelled() || this.cancelFlag.isSet();
        }

        public void close() {
            ThreadUtils.executeLaterInEDT(new Runnable(){

                public void run() {
                    SwingUIHookAdapter.this.closeInUI();
                }
            });
        }

        public void interrupedIO() {
            ThreadUtils.executeLaterInEDT(new Runnable(){

                public void run() {
                    SwingUIHookAdapter.this.interruptedIOInUI();
                }
            });
        }

        private class Runner
        implements Runnable {
            private Vector<UpdateInfo> updateList = new Vector();

            private Runner() {
            }

            public Runnable display(PropertyList type, int progress, int total) {
                this.updateList.add(new UpdateInfo(type, progress, total));
                return this;
            }

            public void run() {
                while (!this.updateList.isEmpty()) {
                    UpdateInfo info = this.updateList.remove(0);
                    switch (info._type) {
                        case Recieve: {
                            SwingUIHookAdapter.this.updateRecieveStatusInUI(info._progress, info._total);
                            break;
                        }
                        case Send: {
                            SwingUIHookAdapter.this.updateSendStatusInUI(info._progress, info._total);
                        }
                    }
                }
            }
        }

        private class UpdateInfo {
            private PropertyList _type;
            private int _total;
            private int _percent;
            private int _progress;

            public UpdateInfo() {
                this._type = PropertyList.Recieve;
                this._total = -1;
                this._percent = -1;
            }

            public UpdateInfo(PropertyList type, int progress, int total) {
                this._type = type;
                this._total = total;
                this._progress = progress;
                this._percent = ProgressMonitorUtils.getProgressPercent(progress, total);
            }

            public void set(PropertyList type, int progress, int total) {
                this._type = type;
                this._total = total;
                this._progress = progress;
                this._percent = ProgressMonitorUtils.getProgressPercent(progress, total);
            }

            public void copyFrom(UpdateInfo update) {
                this._type = update._type;
                this._total = update._total;
                this._progress = update._progress;
                this._percent = update._percent;
            }

            public boolean hasChanged(UpdateInfo rhs) {
                if (rhs == null) {
                    return true;
                }
                return this._type != rhs._type || this._total != rhs._total || this._percent != rhs._percent;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("type=").append((Object)this._type).append(", total=").append(this._total).append(", %=").append(this._percent);
                return sb.toString();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropertyList {
        Send,
        Recieve,
        UnderlyingIOStreamClosed,
        UnderlyingIOStreamInterruped;

    }
}

