/*
 * Decompiled with CFR 0.152.
 */
package Task;

import Task.AutoShutdownSignals;
import Task.Manager.TaskManager;
import Task.ProgressMonitor.SwingUIHookAdapter;
import Task.TaskException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.SwingWorker;
import org.swixml.contrib.gmap.Validate;

public abstract class AbstractTask {
    private SwingUIHookAdapter _uihook = new SwingUIHookAdapter();
    protected AutoShutdownSignals[] _autoShutdownRay = new AutoShutdownSignals[]{AutoShutdownSignals.AppShutdown};
    protected boolean _shutdownCalled = false;
    protected TaskManager _taskManager;
    protected Lock _boundPropertiesLock = new ReentrantLock();
    protected PropertyChangeSupport _boundProperties = new PropertyChangeSupport(this);
    protected String _status;
    protected State _state;
    private String _name = "AbstractTask";
    private String _descr = "DescriptionSet";

    public abstract Type getType();

    public SwingUIHookAdapter getUIHook() {
        return this._uihook;
    }

    public AutoShutdownSignals[] getAutoShutdownPolicy() {
        return this._autoShutdownRay;
    }

    public void setAutoShutdownPolicy(AutoShutdownSignals ... policy) {
        Validate.notNull(policy, "policy can not be null");
        this._autoShutdownRay = policy;
    }

    public boolean isShutdown() {
        return this._shutdownCalled;
    }

    public void shutdown() {
        this._shutdownCalled = true;
        this.clearAllStatusListeners();
        this.doShutdown();
        this.getUIHook().clearAllStatusListeners();
        this.getUIHook().setSwingWorker(null);
    }

    public boolean hasAutoShutdownPolicy(AutoShutdownSignals policy) throws IllegalArgumentException {
        Validate.notNull((Object)policy, "policy can not be null");
        for (AutoShutdownSignals p : this._autoShutdownRay) {
            if (!p.equals((Object)policy)) continue;
            return true;
        }
        return false;
    }

    public abstract void doShutdown();

    protected TaskManager getTaskManager() {
        return this._taskManager;
    }

    protected void setTaskManager(TaskManager container) {
        this._taskManager = container;
    }

    public String getStatus() {
        return this._status;
    }

    public Object getState() {
        return this._state;
    }

    protected PropertyChangeSupport getBoundProperties() {
        return this._boundProperties;
    }

    public void setStatus(String s) {
        if (s != null) {
            this._boundProperties.firePropertyChange(PropertyNames.Status.toString(), null, s);
        }
        this._status = s;
    }

    public void setState(State stateValue) {
        this._state = stateValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatusListener(PropertyChangeListener l) {
        Validate.notNull(l, "PropertyChangeListener for Status can not be null");
        try {
            this._boundPropertiesLock.lock();
            this._boundProperties.addPropertyChangeListener(PropertyNames.Status.toString(), l);
        }
        finally {
            this._boundPropertiesLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllStatusListeners() {
        try {
            PropertyChangeListener[] list;
            this._boundPropertiesLock.lock();
            for (PropertyChangeListener l : list = this._boundProperties.getPropertyChangeListeners(PropertyNames.Status.toString())) {
                this._boundProperties.removePropertyChangeListener(PropertyNames.Status.toString(), l);
            }
        }
        finally {
            this._boundPropertiesLock.unlock();
        }
    }

    public abstract SwingWorker getSwingWorker();

    public abstract void execute() throws TaskException;

    public void cancel() {
        SwingWorker future = this.getSwingWorker();
        if (future != null) {
            future.cancel(true);
        }
    }

    protected void _assertNoSwingWorkerCurrentlyActive() throws TaskException {
        SwingWorker worker = this.getSwingWorker();
        if (worker != null && !worker.isDone() && !worker.isCancelled()) {
            throw TaskException.newConcurrentSwingWorkerCreationAttempt("This task already has one underlying SwingWorker executing. It can't have more than one active concurrently.", this);
        }
        this.getUIHook().resetCancelFlag();
    }

    protected void _assertIsNotShutdown() throws TaskException {
        if (this.isShutdown()) {
            throw TaskException.executionAttemptAfterShutdown("This task can not be executed once it has been shutdown.", this);
        }
    }

    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this._descr;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setDescription(String descr) {
        this._descr = descr;
    }

    public String formattedString() {
        StringBuilder sb = new StringBuilder();
        String name = this.getName() == null ? "n/a" : this.getName();
        String descr = this.getDescription() == null ? "n/a" : this.getDescription();
        String autostop = this._autoShutdownRay == null ? "n/a" : this.getAutoStopPolicyString();
        String state = this.getState() == null ? "n/a" : this.getState().toString();
        String status = this.getStatus() == null ? "n/a" : this.getStatus();
        String tState = this.getSwingWorker() == null ? "n/a" : this.getSwingWorker().getState().toString();
        String tProgress = this.getSwingWorker() == null ? "n/a" : Integer.toString(this.getSwingWorker().getProgress());
        String isCancelled = this.getSwingWorker() == null ? "n/a" : Boolean.toString(this.getSwingWorker().isCancelled());
        sb.append("Name=").append(name).append(", DescriptionSet=").append(descr).append("\n");
        sb.append("AutoStop Policy=").append(autostop).append("\n");
        sb.append("State=").append(state).append(", Status=").append(status).append("\n");
        sb.append("IsCancelled?=").append(isCancelled).append("\n");
        sb.append("ThreadState=").append(tState).append(", ThreadStatus=").append(tProgress);
        return sb.toString();
    }

    private String getAutoStopPolicyString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        int i = 0;
        for (AutoShutdownSignals as : this._autoShutdownRay) {
            sb.append(as.toString());
            if (++i == this._autoShutdownRay.length) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropertyNames {
        Status;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        Started,
        Stopped,
        Interrupted,
        OK,
        Err,
        Cancelled,
        NotOnline;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        NonRecurringTask,
        NonRecurringNetworkTask,
        RecurringNetworkTask;

    }
}

