/*
 * Decompiled with CFR 0.152.
 */
package org.swixml.contrib.gmap;

import org.swixml.contrib.gmap.MapMarker;

public class MapLookup {
    public static final String GMAP_STATIC_URI = "http://maps.google.com/staticmap";
    public static final String GMAP_STATIC_URI_V2 = "https://maps.googleapis.com/maps/api/staticmap";
    public static final String GMAP_LICENSE_KEY = "key";
    public static final String CENTER_KEY = "center";
    public static final String ZOOM_KEY = "zoom";
    public static final int ZOOM_DEFAULT = 10;
    public static final String SIZE_KEY = "size";
    public static final String SIZE_SEPARATOR = "x";
    public static final int SIZE_DEFAULT = 512;
    public static final String MARKER_SEPARATOR = "|";
    public static final String MARKERS_KEY = "markers";
    private String GmapLicense = "";
    private int SizeMin = 10;
    private int SizeMax = 512;
    private int ZoomMin = 0;
    private int ZoomMax = 19;

    public String getLicenseKey() {
        return this.GmapLicense;
    }

    public void setLicenseKey(String lic) {
        this.GmapLicense = lic;
    }

    public String getMap(double lat, double lon, int sizeW, int sizeH, int zoom, MapMarker ... markers) {
        return this.getURI(lat, lon, sizeW, sizeH, zoom, markers);
    }

    public String getURI(double lat, double lon, int sizeW, int sizeH, int zoom, MapMarker ... markers) {
        this._validateParams(sizeW, sizeH, zoom);
        StringBuilder sb = new StringBuilder();
        sb.append(GMAP_STATIC_URI_V2);
        sb.append("?").append(CENTER_KEY).append("=").append(lat).append(",").append(lon);
        sb.append("&").append(ZOOM_KEY).append("=").append(zoom);
        sb.append("&").append(SIZE_KEY).append("=").append(sizeW).append(SIZE_SEPARATOR).append(sizeH);
        sb.append("&").append(MarkerUtils.toString(new MapMarker(lat, lon)));
        sb.append("&").append(GMAP_LICENSE_KEY).append("=").append(this.GmapLicense);
        sb.append("&").append("sensor").append("=").append("false");
        return sb.toString();
    }

    private void _validateParams(int sizeW, int sizeH, int zoom) {
    }

    public static class MarkerUtils {
        public static String toString(MapMarker ... markers) {
            if (markers.length > 0) {
                StringBuilder sb = new StringBuilder();
                sb.append(MapLookup.MARKERS_KEY).append("=");
                for (int i = 0; i < markers.length; ++i) {
                    sb.append(markers[i].toString());
                    if (i == markers.length - 1) continue;
                    sb.append(MapLookup.MARKER_SEPARATOR);
                }
                return sb.toString();
            }
            return "";
        }
    }
}

