/*
 * Decompiled with CFR 0.152.
 */
package org.swixml.contrib;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceConverter;
import org.jdesktop.application.ResourceMap;
import org.swixml.LogUtil;

public class JAnimatedButton
extends JToggleButton
implements ActionListener {
    private static final int DEFAULT_DELAY = 1000;
    private static final int DEFAULT_START_DELAY = 200;
    private final Timer timer = new Timer(200, this);
    private ImageIcon[] icons = null;
    private int imageIconIndex = 0;
    private int iconCount = 0;
    private ItemListener _itemListener = new ItemListener(){

        public void itemStateChanged(ItemEvent e) {
            if (JAnimatedButton.this.timer.isRunning()) {
                JAnimatedButton.this.stop();
            } else {
                JAnimatedButton.this.start();
            }
        }
    };

    public JAnimatedButton() {
        this.timer.setInitialDelay(200);
        this.timer.setDelay(1000);
    }

    public boolean isStateChangedEnabled() {
        return Boolean.TRUE.equals(this.getClientProperty("stateChangedEnabled"));
    }

    public void setStateChangedEnabled(boolean value) {
        this.putClientProperty("stateChangedEnabled", value);
    }

    public final boolean isRunning() {
        return this.timer.isRunning();
    }

    public int getIconCount() {
        return this.iconCount;
    }

    public void setIconCount(int imageCount) {
        if (imageCount < 0) {
            throw new IllegalArgumentException("imageCount is less than 0!");
        }
        this.iconCount = imageCount;
    }

    public void setDelay(int delay) {
        this.timer.setDelay(delay);
    }

    public void actionPerformed(ActionEvent event) {
        this.setIcon(this.icons[this.imageIconIndex++]);
        if (this.imageIconIndex >= this.icons.length) {
            this.imageIconIndex = 0;
        }
    }

    private boolean isAnimationValid() {
        return this.icons != null && this.icons.length > 1;
    }

    public final void start() {
        if (!this.isAnimationValid()) {
            return;
        }
        this.imageIconIndex = 1;
        this.timer.restart();
    }

    public final void stop() {
        if (!this.isAnimationValid()) {
            return;
        }
        this.timer.stop();
        this.imageIconIndex = 0;
        this.setIcon(this.icons[this.imageIconIndex]);
    }

    private void loadFromResource() {
        if (this.iconCount <= 0) {
            throw new IllegalStateException("icon Count value is invalid");
        }
        String name = super.getName();
        if (name == null) {
            throw new IllegalStateException("name is null!");
        }
        Application app = Application.getInstance();
        if (app == null) {
            throw new IllegalStateException("application is not present!");
        }
        ApplicationContext context = app.getContext();
        ResourceMap rm = context.getResourceMap();
        this.icons = new ImageIcon[this.iconCount];
        ResourceConverter converter = ResourceConverter.forType(ImageIcon.class);
        for (int i = 0; i < this.iconCount; ++i) {
            String iconIndex = String.format("icon%d", i);
            String icon = String.format("%s.%s", name, iconIndex);
            if (rm.containsKey(icon)) {
                this.icons[i] = rm.getImageIcon(icon);
                continue;
            }
            String iconPath = (String)super.getClientProperty(iconIndex);
            if (converter != null && iconPath != null) {
                try {
                    this.icons[i] = (ImageIcon)converter.parseString(iconPath, rm);
                }
                catch (ResourceConverter.ResourceConverterException ex) {
                    LogUtil.logger.warning(String.format("icon [%s] not found ", iconPath));
                    this.icons[i] = null;
                }
                continue;
            }
            this.icons[i] = null;
        }
        this.imageIconIndex = 0;
        this.setIcon(this.icons[this.imageIconIndex]);
    }

    public void addNotify() {
        super.addNotify();
        if (this.iconCount <= 0) {
            return;
        }
        this.loadFromResource();
        if (this.isStateChangedEnabled()) {
            this.addItemListener(this._itemListener);
        }
    }

    public void removeNotify() {
        this.stop();
        this.icons = null;
        this.removeItemListener(this._itemListener);
        super.removeNotify();
    }
}

