/*
 * Decompiled with CFR 0.152.
 */
package Task;

import Task.AbstractTask;
import Task.AutoShutdownSignals;
import Task.Manager.TaskManager;
import Task.NetworkTask;
import Task.TaskException;
import Task.TaskExecutorIF;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecurringNetworkTask<ReturnValueType>
extends NetworkTask<ReturnValueType> {
    protected int _refreshDelayInSec = 30;
    protected ScheduledExecutorService _execService;
    protected ScheduledFuture _scheduledFuture;

    @Override
    public AbstractTask.Type getType() {
        return AbstractTask.Type.RecurringNetworkTask;
    }

    public RecurringNetworkTask(TaskManager container, TaskExecutorIF<ReturnValueType> exec, String name, String descr, AutoShutdownSignals ... policy) throws IllegalArgumentException {
        super(container, exec, name, descr, policy);
    }

    @Override
    public void doShutdown() {
        this.stopRecurring();
        this._taskHandler.shutdownCalled(this);
    }

    public RecurringNetworkTask(TaskExecutorIF<ReturnValueType> exec) {
        super(exec);
    }

    public void start(int refreshDelayInSec) throws TaskException {
        this.setRefreshDelay(refreshDelayInSec);
        this._initScheduledFuture();
    }

    public void start() throws TaskException {
        this._initScheduledFuture();
    }

    public void restartWithNewDelay(int refreshDelayInSec) throws TaskException {
        this.setRefreshDelay(refreshDelayInSec);
        this._cancelScheduledFuture();
        this._initScheduledFuture();
    }

    protected void _initScheduledFuture() throws TaskException {
        this._assertIsNotShutdown();
        if (this._scheduledFuture != null) {
            return;
        }
        this._execService = Executors.newScheduledThreadPool(1);
        this._scheduledFuture = this._execService.scheduleWithFixedDelay(new Runnable(){

            public void run() {
                try {
                    RecurringNetworkTask.this.executeAndWait();
                }
                catch (TaskException e) {
                    RecurringNetworkTask.this._taskManager.writeExceptionToLog(Level.WARNING, RecurringNetworkTask.this.getName() + "shutting down", e);
                    RecurringNetworkTask.this.shutdown();
                }
            }
        }, 0L, this._refreshDelayInSec, TimeUnit.SECONDS);
    }

    protected void _cancelScheduledFuture() {
        if (this._scheduledFuture == null) {
            return;
        }
        this._scheduledFuture.cancel(true);
        this.cancel();
        this._scheduledFuture = null;
    }

    public void stopRecurring() {
        if (this._execService != null) {
            this._execService.shutdown();
            this._execService = null;
        }
        this._cancelScheduledFuture();
    }

    public void setRefreshDelay(int refreshDelayInSec) {
        this._refreshDelayInSec = refreshDelayInSec;
    }
}

