/*
 * Decompiled with CFR 0.152.
 */
package Task.ProgressMonitor;

import Task.ProgressMonitor.SwingUIHookAdapter;
import java.beans.PropertyChangeEvent;

public class ProgressMonitorUtils {
    public static final String generateProgressMessage(Type type, String msg, int progress, int total) {
        StringBuilder sb = new StringBuilder();
        if (msg != null) {
            sb.append(msg).append(" : ");
        }
        switch (type) {
            case Recieve: {
                sb.append("Downloading : ");
                break;
            }
            case Send: {
                sb.append("Uploading : ");
            }
        }
        if (total < 0 || progress < 0 || progress > total) {
            sb.append("please wait...");
        } else if (total != 0) {
            sb.append(ProgressMonitorUtils.getProgressPercent(progress, total)).append(" % complete.");
        } else {
            sb.append("please wait...");
        }
        return sb.toString();
    }

    public static final int getProgressPercent(int progress, int total) {
        try {
            return progress * 100 / total;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static int parsePercentFrom(PropertyChangeEvent evt) {
        int percent = Integer.parseInt(evt.getOldValue().toString());
        return percent;
    }

    public static String parseMessageFrom(PropertyChangeEvent evt) {
        return evt.getNewValue().toString();
    }

    public static SwingUIHookAdapter.PropertyList parseTypeFrom(PropertyChangeEvent evt) {
        return SwingUIHookAdapter.PropertyList.valueOf(evt.getPropertyName());
    }

    public static String parseStatusMessageFrom(PropertyChangeEvent evt) {
        return evt.getNewValue().toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        Send,
        Recieve;

    }
}

