/*
 * Decompiled with CFR 0.152.
 */
package Task.Manager;

import Task.AbstractTask;
import Task.AutoShutdownSignals;
import Task.Manager.TaskListChangeEvent;
import Task.Manager.TaskListChangeListener;
import Task.Support.EnhancedListeners.EnhancedListenerManager;
import Task.Support.EnhancedListeners.ExecutionDelegate;
import Task.TaskException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.swixml.contrib.gmap.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskManager
extends EnhancedListenerManager<TaskListChangeListener> {
    private static Logger LOG = Logger.getLogger(TaskManager.class.getName());
    private CopyOnWriteArrayList<AbstractTask> _taskList = new CopyOnWriteArrayList();
    private boolean _isOnline = true;

    public void offline() {
        this._isOnline = false;
    }

    public void online() {
        this._isOnline = true;
    }

    public boolean isOnline() {
        return this._isOnline;
    }

    public void shutdownAll() {
        for (AbstractTask task : this._taskList) {
            task.shutdown();
            this._fireTaskListChange(new TaskListChangeEvent(TaskListChangeEvent.Type.Shutdown, task));
        }
        this._removeStoppedTasksFromList();
        this.pruneSoftListeners();
    }

    public void autoShutdownOn(AutoShutdownSignals stopOnThis) {
        for (AbstractTask task : this._taskList) {
            if (!task.hasAutoShutdownPolicy(stopOnThis)) continue;
            task.shutdown();
            this._fireTaskListChange(new TaskListChangeEvent(TaskListChangeEvent.Type.Shutdown, task));
        }
        this._removeStoppedTasksFromList();
    }

    public void registerTask(AbstractTask task) throws IllegalArgumentException {
        Validate.notNull(task, "TaskRoot can not be null");
        this._taskList.add(task);
        this._fireTaskListChange(new TaskListChangeEvent(TaskListChangeEvent.Type.Register, task));
    }

    public void unregisterTask(AbstractTask task) throws IllegalArgumentException {
        Validate.notNull(task, "TaskRoot can not be null");
        this._taskList.remove(task);
        this._fireTaskListChange(new TaskListChangeEvent(TaskListChangeEvent.Type.Unregister, task));
    }

    private void _removeStoppedTasksFromList() {
        ArrayList<AbstractTask> isStoppedList = new ArrayList<AbstractTask>();
        for (AbstractTask task : this._taskList) {
            if (!task.isShutdown()) continue;
            isStoppedList.add(task);
            this._fireTaskListChange(new TaskListChangeEvent(TaskListChangeEvent.Type.Unregister, task));
        }
        this._taskList.removeAll(isStoppedList);
    }

    public List<AbstractTask> getCopyOfList() {
        return new ArrayList<AbstractTask>(this._taskList);
    }

    private void _fireTaskListChange(TaskListChangeEvent evt) {
        this.fireUpdateToListeners(evt, new ExecutionDelegate<TaskListChangeEvent, TaskListChangeListener>(){

            @Override
            public void doFireEvent(TaskListChangeListener listener, TaskListChangeEvent event) {
                listener.taskListChanged(event);
            }
        });
    }

    public void writeExceptionToLog(Level warning, String s, TaskException e) {
        LOG.log(warning, s, e);
    }
}

