package javax.microedition.amms;

import java.io.OutputStream;

import javax.microedition.amms.control.ImageFormatControl;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Control;
import java.awt.image.BufferedImage;

public class AwtJpegEncoder implements MediaProcessor, ImageFormatControl {

    String format;
    Image image;
    OutputStream outputStream;

    public void complete() throws javax.microedition.media.MediaException {

        String imageIOformat = format.substring( "image/".length() );
        Throwable error;
        
        try {
            if (!javax.imageio.ImageIO.write(image._image, imageIOformat, outputStream) ) {
                throw new Exception("ImageIO.write return false");
            }

            return; // yay, everything worked!
        }
        catch(Throwable th) {
            System.out.println("could not save1 " + th);
            error = th;
        }
        
        if ("jpg".equalsIgnoreCase(imageIOformat) || "jpeg".equalsIgnoreCase(imageIOformat)) {

            BufferedImage img = image._image;
            if (img.getType() == BufferedImage.TYPE_INT_ARGB || img.getType() == BufferedImage.TYPE_4BYTE_ABGR) {

                try {
                    System.out.println("failed to save with ImageIO, will try TYPE_3BYTE_BGR image type");
                    // there is some bug in openJDK that does not allow saving images with alpha as JPEGs
                    // https://stackoverflow.com/a/17845696
                    BufferedImage newImg = new BufferedImage(img.getWidth(), img.getHeight(), BufferedImage.TYPE_3BYTE_BGR);
                    newImg.getGraphics().drawImage(img, 0, 0, null);

                    if (!javax.imageio.ImageIO.write(newImg, imageIOformat, outputStream) ) {
                        throw new Exception("ImageIO.write return false");
                    }

                    return; // yay, everything worked!
                }
                catch (Throwable th) {
                    System.out.println("could not save2 " + th);
                    error = th;
                }
            }

            try {
                System.out.println("failed to save with ImageIO, falling back to com.sun.image.codec.jpeg");
                com.sun.image.codec.jpeg.JPEGImageEncoder encoder = com.sun.image.codec.jpeg.JPEGCodec.createJPEGEncoder(outputStream);
                com.sun.image.codec.jpeg.JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(img);
                param.setQuality(0.5f, false);
                encoder.setJPEGEncodeParam(param);
                encoder.encode(img);
                outputStream.close();

                return; // yay, everything worked!
            }
            catch (Throwable th) {
                System.out.println("could not save3 " + th);
                // anything really can go wrong here, but we do not really care
            }
        }

        // all methods to save have failed, throw an error
        javax.microedition.media.MediaException mex = new javax.microedition.media.MediaException();
        mex.initCause(error);
        throw mex;
    }

    public void setInput(Object inputStream) {
        this.image = (Image)inputStream;
    }

    public void setOutput(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public Control getControl(String controlType) {
        return this;
    }

    public Control[] getControls() {
        throw new RuntimeException();
    }

    public void setFormat(String string) {
        format = string;
    }
}
