/*
 * Decompiled with CFR 0.152.
 */
package org.swblocks.jbl.util.retry;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.swblocks.jbl.eh.EhSupport;
import org.swblocks.jbl.eh.Result;
import org.swblocks.jbl.util.retry.ActionRetrier;

public final class Retrier {
    public static final long TIME_GENERATOR_DEFAULT_DELAY_IN_MILLISECONDS = 100L;
    public static final long TIME_GENERATOR_DEFAULT_CAPPED_DELAY_IN_MILLISECONDS = TimeUnit.MINUTES.toMillis(5L);
    public static final long TIME_GENERATOR_DEFAULT_STEP_MULTIPLIER = 10L;
    public static final int TIME_GENERATOR_DEFAULT_RETRIES_BETWEEN_STEPS = 5;
    public static final Supplier<Iterator<Long>> DEFAULT_CAPPED_INCREMENTING_TIME_GENERATOR = Retrier.createCappedIncrementingTimeGenerator(100L, TIME_GENERATOR_DEFAULT_CAPPED_DELAY_IN_MILLISECONDS, 10L, 5);
    public static final Supplier<Iterator<Long>> DEFAULT_CONSTANT_TIME_GENERATOR = Retrier.createConstantTimeGenerator(100L);

    private Retrier() {
    }

    public static <T> Predicate<Result<T>> createDefaultExceptionPredicate() {
        return Retrier.exceptionsFilterPredicate(Exception.class);
    }

    public static <T> Predicate<Result<T>> exceptionsFilterPredicate(Class ... recoverableTypes) {
        return result -> {
            EhSupport.ensureOrFatal(!result.isSuccess(), "Successful operations should not be retried", new Object[0]);
            for (Throwable exception = result.getException(); exception != null; exception = exception.getCause()) {
                if (!Retrier.matchAssignableFromClass(exception.getClass(), recoverableTypes)) continue;
                return true;
            }
            return false;
        };
    }

    public static <T> ActionRetrier<T> createNonRetrier() {
        return (action, shouldRetry) -> (Result)action.get();
    }

    public static <T> ActionRetrier<T> createDefaultSingleSleepRetrier() {
        return Retrier.createSleepRetrier(DEFAULT_CONSTANT_TIME_GENERATOR, 1);
    }

    public static <T> ActionRetrier<T> createDefaultContinuousConstantSleepRetrier() {
        return Retrier.createContinuousSleepRetrier(DEFAULT_CONSTANT_TIME_GENERATOR);
    }

    public static <T> ActionRetrier<T> createDefaultCappedIncrementingRetrier() {
        return Retrier.createSleepRetrier(DEFAULT_CAPPED_INCREMENTING_TIME_GENERATOR, 5);
    }

    public static <T> ActionRetrier<T> createDefaultContinuousCappedIncrementingRetrier() {
        return Retrier.createContinuousSleepRetrier(DEFAULT_CAPPED_INCREMENTING_TIME_GENERATOR);
    }

    public static <T> ActionRetrier<T> createSleepRetrier(Supplier<Iterator<Long>> timeGenerator, int numberOfRetries) {
        return (action, shouldRetry) -> {
            EhSupport.ensureArg(numberOfRetries > 0, "numberOfRetries %s should be a positive number", numberOfRetries);
            Iterator sleepTimes = (Iterator)timeGenerator.get();
            Result result = Result.failure(() -> new IllegalStateException("Result not expected to be used"));
            for (int i = 0; i < numberOfRetries; ++i) {
                result = (Result)action.get();
                if (result.isSuccess()) {
                    return result;
                }
                if (!shouldRetry.test(result)) continue;
                EhSupport.propagate(() -> Thread.sleep((Long)sleepTimes.next()));
            }
            return result;
        };
    }

    public static <T> ActionRetrier<T> createContinuousSleepRetrier(Supplier<Iterator<Long>> timeGenerator) {
        return (action, shouldRetry) -> {
            Result result;
            Iterator sleepTimes = (Iterator)timeGenerator.get();
            while (!(result = (Result)action.get()).isSuccess() && shouldRetry.test(result)) {
                EhSupport.propagate(() -> Thread.sleep((Long)sleepTimes.next()));
            }
            return result;
        };
    }

    public static Supplier<Iterator<Long>> createConstantTimeGenerator(final long timeInMiliseconds) {
        return () -> new Iterator<Long>(){

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public Long next() {
                if (timeInMiliseconds == 0L) {
                    throw new NoSuchElementException("No pause time specified");
                }
                return timeInMiliseconds;
            }
        };
    }

    public static Supplier<Iterator<Long>> createCappedIncrementingTimeGenerator(long initialDelayInMillis, long cappedDelayInMillis, long stepMultiplier, int retriesBetweenSteps) {
        return () -> new CappedIncrementingTimeGeneratorIterator(initialDelayInMillis, cappedDelayInMillis, stepMultiplier, retriesBetweenSteps);
    }

    private static boolean matchAssignableFromClass(Class type, Class ... types) {
        for (Class matchedType : types) {
            if (!matchedType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    private static class CappedIncrementingTimeGeneratorIterator
    implements Iterator<Long> {
        private final long cappedDelayInMillis;
        private final long stepMultiplier;
        private final int retriesBetweenSteps;
        private int retries = 0;
        private long currentDelay;

        public CappedIncrementingTimeGeneratorIterator(long initialDelayInMillis, long cappedDelayInMillis, long stepMultiplier, int retriesBetweenSteps) {
            this.cappedDelayInMillis = cappedDelayInMillis;
            this.stepMultiplier = stepMultiplier;
            this.retriesBetweenSteps = retriesBetweenSteps;
            this.currentDelay = initialDelayInMillis;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public Long next() {
            if (this.currentDelay < this.cappedDelayInMillis && this.retries >= this.retriesBetweenSteps) {
                this.retries = 0;
                this.currentDelay = Math.min(this.currentDelay * this.stepMultiplier, this.cappedDelayInMillis);
            }
            ++this.retries;
            if (this.currentDelay == 0L) {
                throw new NoSuchElementException("No pause time specified");
            }
            return this.currentDelay;
        }
    }
}

