/*
 * Decompiled with CFR 0.152.
 */
package org.swblocks.jbl.util;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public class Range<T extends Comparable<? super T>>
implements Predicate<T> {
    public static final BiPredicate<Range, Comparable> RANGE_CHECK = (range, test) -> test.compareTo(range.getStart()) >= 0 && test.compareTo(range.getFinish()) < 0;
    private T start;
    private T finish;

    public Range(T start, T finish) {
        this.start = start;
        this.finish = finish;
    }

    @Override
    public boolean test(T value) {
        return value.compareTo(this.getStart()) >= 0 && value.compareTo(this.getFinish()) < 0;
    }

    public T getStart() {
        return this.start;
    }

    public T getFinish() {
        return this.finish;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            Range other = (Range)obj;
            return Objects.equals(this.getStart(), other.getStart()) && Objects.equals(this.getFinish(), other.getFinish());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.start) + Objects.hashCode(this.finish);
    }
}

