/*
 * Decompiled with CFR 0.152.
 */
package org.swblocks.jbl.test.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.swblocks.jbl.collections.CollectionUtils;
import org.swblocks.jbl.eh.EhSupport;
import org.swblocks.jbl.eh.Result;

public class JblTestClassUtils {
    private JblTestClassUtils() {
    }

    public static boolean assertConstructorIsPrivate(Class clazz) {
        return EhSupport.propagateFn(() -> {
            Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
            boolean isPrivate = Modifier.isPrivate(constructor.getModifiers());
            constructor.setAccessible(true);
            constructor.newInstance(new Object[0]);
            constructor.setAccessible(false);
            return isPrivate;
        });
    }

    public static <T> boolean assertGetterCorrectForConstructorInjection(Map<String, Object> injectedValues, T bean) {
        EhSupport.ensureArg(CollectionUtils.isNotEmpty(injectedValues), "Injected property values are not present", new Object[0]);
        EhSupport.ensureArg(bean != null, "Test bean is null", new Object[0]);
        Set<String> properties = injectedValues.keySet();
        Result result = EhSupport.propagateFn(() -> {
            for (String property : properties) {
                Object exampleValue = injectedValues.get(property);
                String capitalisedProperty = property.substring(0, 1).toUpperCase(Locale.ENGLISH) + property.substring(1);
                String getterName = "get" + capitalisedProperty;
                Object value = bean.getClass().getMethod(getterName, new Class[0]).invoke(bean, new Object[0]);
                EhSupport.ensure(exampleValue.equals(value), "Constructor broken for property %s", property);
            }
            return Result.success(bean);
        });
        return result.isSuccess();
    }

    public static <T> boolean assertSettersAndGettersCorrect(Map<String, Object> injectedValues, T bean, Map<String, Class> typeOverrides) {
        EhSupport.ensureArg(CollectionUtils.isNotEmpty(injectedValues), "Injected property values are not present", new Object[0]);
        EhSupport.ensureArg(bean != null, "Test bean is null", new Object[0]);
        Set<String> properties = injectedValues.keySet();
        Result result = EhSupport.propagateFn(() -> {
            for (String property : properties) {
                Object exampleValue = injectedValues.get(property);
                Class classType = typeOverrides.containsKey(property) ? (Class)typeOverrides.get(property) : exampleValue.getClass();
                String capitalisedProperty = property.substring(0, 1).toUpperCase(Locale.ENGLISH) + property.substring(1);
                String setterName = "set" + capitalisedProperty;
                bean.getClass().getMethod(setterName, classType).invoke(bean, exampleValue);
                String getterName = "get" + capitalisedProperty;
                Object value = bean.getClass().getMethod(getterName, new Class[0]).invoke(bean, new Object[0]);
                EhSupport.ensure(exampleValue.equals(value), "Constructor broken for property %s", property);
            }
            return Result.success(bean);
        });
        return result.isSuccess();
    }
}

