/*
 * Decompiled with CFR 0.152.
 */
package org.swblocks.jbl.tasks;

import java.nio.channels.AsynchronousChannelGroup;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ThreadFactory;
import org.swblocks.jbl.eh.EhSupport;
import org.swblocks.jbl.tasks.ThreadPool;

public class DefaultThreadPool
implements ThreadPool {
    private static final ThreadFactory defaultFactory = Executors.defaultThreadFactory();
    private final ThreadPool.ThreadPoolId id;
    private ExecutorService executorService;
    private AsynchronousChannelGroup ioService;

    private DefaultThreadPool(int numberOfThreads, ThreadPool.ThreadPoolId id) {
        this.id = id;
        this.executorService = ThreadPool.ThreadPoolId.WorkStealing == id ? new ForkJoinPool(numberOfThreads, ForkJoinPool.defaultForkJoinWorkerThreadFactory, EhSupport.getUncaughtHandler(), true) : Executors.newFixedThreadPool(numberOfThreads, runnable -> defaultFactory.newThread(() -> EhSupport.fatalOnException(() -> {
            Thread.currentThread().setUncaughtExceptionHandler(EhSupport.getUncaughtHandler());
            runnable.run();
        })));
        if (ThreadPool.ThreadPoolId.NonBlocking == this.id) {
            try {
                this.ioService = EhSupport.propagateFn(() -> AsynchronousChannelGroup.withThreadPool(this.executorService));
            }
            catch (Throwable throwable) {
                this.executorService.shutdownNow();
                throw throwable;
            }
        } else {
            this.ioService = null;
        }
    }

    @Override
    public void shutdown() {
        EhSupport.fatalOnException(() -> {
            if (null != this.ioService) {
                this.ioService.shutdownNow();
                this.ioService = null;
            }
            this.executorService.shutdown();
            this.executorService = null;
        });
    }

    @Override
    public ThreadPool.ThreadPoolId id() {
        return this.id;
    }

    @Override
    public AsynchronousChannelGroup ioService() {
        EhSupport.ensureOrFatal(null != this.ioService, "I/O service requested for thread pool which does not support it", new Object[0]);
        return this.ioService;
    }

    @Override
    public ExecutorService executorService() {
        EhSupport.ensureOrFatal(null != this.executorService, "The executor service requested for thread pool is not available", new Object[0]);
        return this.executorService;
    }

    public static ThreadPool getInstance(ThreadPool.ThreadPoolId threadPoolId) {
        return EhSupport.propagateFn(() -> {
            switch (threadPoolId) {
                case GeneralPurpose: {
                    return LazyInitializerGeneralPurpose.instance;
                }
                case WorkStealing: {
                    return LazyInitializerWorkStealing.instance;
                }
                case NonBlocking: {
                    return LazyInitializerNonBlocking.instance;
                }
            }
            throw EhSupport.enhance(new IllegalStateException(String.format("The requested thread pool id {} is not supported", new Object[]{threadPoolId})));
        });
    }

    private static class LazyInitializerNonBlocking {
        private static final int NUMBER_OF_THREADS_NON_BLOCKING = 8;
        private static final ThreadPool instance = new DefaultThreadPool(8, ThreadPool.ThreadPoolId.NonBlocking);

        private LazyInitializerNonBlocking() {
        }
    }

    private static class LazyInitializerWorkStealing {
        private static final int PARALLELISM_LEVEL_DEFAULT = Runtime.getRuntime().availableProcessors();
        private static final ThreadPool instance = new DefaultThreadPool(PARALLELISM_LEVEL_DEFAULT, ThreadPool.ThreadPoolId.WorkStealing);

        private LazyInitializerWorkStealing() {
        }
    }

    private static class LazyInitializerGeneralPurpose {
        private static final int NUMBER_OF_THREADS_DEFAULT = 32;
        private static final ThreadPool instance = new DefaultThreadPool(32, ThreadPool.ThreadPoolId.GeneralPurpose);

        private LazyInitializerGeneralPurpose() {
        }
    }
}

