/*
 * Decompiled with CFR 0.152.
 */
package org.swblocks.jbl.monitoring;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Supplier;

public final class Timer {
    private static final double NANOS_PER_SECOND = 1.0E9;
    private static final double MILLIS_PER_SECOND = 1000000.0;
    private final Supplier<Instant> currentTimeGeneration;
    private Instant startTime;
    private Instant stopTime;
    private Instant lapTime;

    private Timer(Supplier<Instant> currentTime) {
        this.currentTimeGeneration = currentTime;
    }

    public static Timer createStarted() {
        return Timer.createStarted(Instant::now);
    }

    static Timer createStarted(Supplier<Instant> currentTimeGeneration) {
        Timer timer = new Timer(currentTimeGeneration);
        timer.start();
        return timer;
    }

    public String stopAndPrintAsReadableString() {
        this.stop();
        return this.asReadableString();
    }

    public String lapAndPrintAsReadableString() {
        return this.asReadableString(this.lap().toNanos());
    }

    public Duration getDuration() {
        return Duration.between(this.startTime, this.stopTime);
    }

    public Duration getLapDuration() {
        return Duration.between(this.startTime, this.lapTime);
    }

    public void start() {
        this.stopTime = this.startTime = this.currentTimeGeneration.get();
        this.lapTime = this.startTime;
    }

    void stop() {
        if (this.stopTime == this.startTime) {
            this.stopTime = this.currentTimeGeneration.get();
        }
    }

    Duration lap() {
        Instant currentLap = this.lapTime;
        this.lapTime = this.currentTimeGeneration.get();
        return Duration.between(currentLap, this.lapTime);
    }

    private String asReadableString() {
        return this.asReadableString(this.getDurationInNanos());
    }

    private String asReadableString(long duration) {
        if ((double)duration > 1.0E9) {
            return this.asSecString(duration) + " seconds";
        }
        if ((double)duration > 100000.0) {
            return this.asMilliString(duration) + " milliseconds";
        }
        return this.asNanoString(duration) + " nanoseconds";
    }

    private String asNanoString(long duration) {
        return Long.toString(duration);
    }

    private String asMilliString(long duration) {
        return Double.toString((double)duration / 1000000.0);
    }

    private String asSecString(long duration) {
        return Double.toString((double)duration / 1.0E9);
    }

    private long getDurationInNanos() {
        return this.getDuration().toNanos();
    }
}

