/*
 * Decompiled with CFR 0.152.
 */
package org.swblocks.jbl.lifecycle;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import org.swblocks.jbl.eh.EhSupport;
import org.swblocks.jbl.lifecycle.ComponentLifecycle;

public final class ComponentLoaderUtils {
    private ComponentLoaderUtils() {
    }

    static void addExternalPathToClasspath(String newUrl) {
        EhSupport.propagate(() -> {
            File file = new File(newUrl);
            URI uri = file.toURI();
            if (file.exists()) {
                URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
                Class<URLClassLoader> urlClass = URLClassLoader.class;
                Method method = urlClass.getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                method.invoke((Object)urlClassLoader, uri.toURL());
            }
        });
    }

    public static ComponentLifecycle instanceOfLifecycleComponent(String resource, String className) {
        return EhSupport.propagateFn(() -> {
            Class<?> clazz;
            Object object;
            URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            if (resource != null && !resource.isEmpty() && urlClassLoader.findResource(resource) == null) {
                ComponentLoaderUtils.addExternalPathToClasspath(resource);
            }
            if ((object = (clazz = urlClassLoader.loadClass(className)).getConstructor(new Class[0]).newInstance(new Object[0])) instanceof ComponentLifecycle) {
                return (ComponentLifecycle)object;
            }
            return null;
        });
    }
}

