/*
 * Decompiled with CFR 0.152.
 */
package org.swblocks.jbl.lifecycle;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.swblocks.jbl.lifecycle.ComponentLifecycle;

public class ComponentLifecycleManager
implements ComponentLifecycle {
    private static final Comparator<ComponentLifecycle> PHASE_COMPARATOR = Comparator.comparingInt(ComponentLifecycle::getPhase);
    private final List<ComponentLifecycle> components;
    private boolean running = false;

    public ComponentLifecycleManager(List<ComponentLifecycle> components) {
        this.components = Collections.unmodifiableList(components);
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void start() {
        if (!this.isRunning()) {
            this.components.stream().sorted(PHASE_COMPARATOR).filter(listener -> !listener.isRunning()).forEach(ComponentLifecycle::start);
        }
        this.running = true;
    }

    @Override
    public void stop() {
        if (this.isRunning()) {
            this.components.stream().sorted(PHASE_COMPARATOR.reversed()).filter(ComponentLifecycle::isRunning).forEach(ComponentLifecycle::stop);
        }
        this.running = false;
    }
}

