/*
 * Decompiled with CFR 0.152.
 */
package org.swblocks.jbl.eh;

import java.util.function.Supplier;
import org.swblocks.jbl.eh.EhSupport;

public final class Result<T> {
    private final boolean isSuccess;
    private final T data;
    private final Supplier<Exception> exceptionSupplier;
    private Exception exception;

    private Result(boolean isSuccess, T data, Supplier<Exception> exceptionSupplier) {
        this.isSuccess = isSuccess;
        this.data = data;
        this.exceptionSupplier = exceptionSupplier;
        this.exception = null;
    }

    public static <T> Result<T> success(T data) {
        return new Result<T>(true, data, null);
    }

    public static <T> Result<T> failure(Supplier<Exception> exceptionSupplier) {
        return new Result<Object>(false, null, exceptionSupplier);
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public T getData() {
        EhSupport.ensureOrFatal(this.isSuccess(), "Result.getData is called on failed operation", new Object[0]);
        return this.data;
    }

    public Exception getException() {
        EhSupport.ensureOrFatal(!this.isSuccess(), "Result.getException is called on successful operation", new Object[0]);
        if (this.exception == null && this.exceptionSupplier != null) {
            this.exception = this.exceptionSupplier.get();
        }
        EhSupport.ensureOrFatal(this.exception != null, "Result.getException - exception not provided", new Object[0]);
        return this.exception;
    }
}

