/*
 * Decompiled with CFR 0.152.
 */
package org.swblocks.jbl.eh;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.time.Instant;
import java.util.function.Consumer;
import java.util.function.Function;
import org.swblocks.jbl.eh.BaseException;
import org.swblocks.jbl.eh.EhCoreSupport;
import org.swblocks.jbl.eh.PropertiesHolderException;
import org.swblocks.jbl.eh.Result;
import org.swblocks.jbl.functional.ThrowsRunnable;
import org.swblocks.jbl.functional.ThrowsSupplier;

public final class EhSupport
extends EhCoreSupport {
    private EhSupport() {
    }

    public static BaseException getPropertiesException(Throwable exception) {
        if (exception instanceof BaseException) {
            return (BaseException)exception;
        }
        Throwable search = exception;
        Throwable cause = search.getCause();
        while (cause != null && !(cause instanceof BaseException)) {
            search = cause;
            cause = search.getCause();
        }
        if (cause != null) {
            return (BaseException)cause;
        }
        PropertiesHolderException result = new PropertiesHolderException(exception);
        search.initCause(result);
        return result;
    }

    public static Throwable enhance(Throwable exception) {
        EhSupport.getPropertiesException(exception);
        return exception;
    }

    public static Throwable enhance(Throwable exception, String name, Object value) {
        EhSupport.getPropertiesException(exception).putProperty(name, value);
        return exception;
    }

    public static void throwEnhanced(Throwable exception) {
        EhSupport.rethrow(EhSupport.enhance(exception));
    }

    public static void throwEnhanced(Throwable exception, String name, Object value) {
        EhSupport.rethrow(EhSupport.enhance(exception, name, value));
    }

    public static void enhanceAndRethrow(ThrowsRunnable callback, Consumer<BaseException> enhanceCallback) {
        try {
            callback.run();
        }
        catch (Throwable exception) {
            enhanceCallback.accept(EhSupport.getPropertiesException(exception));
            EhSupport.rethrow(exception);
        }
    }

    public static void enhanceAndRethrow(ThrowsRunnable callback, String name, Object value) {
        EhSupport.enhanceAndRethrow(callback, baseException -> baseException.putProperty(name, value));
    }

    public static <R> R enhanceAndRethrowFn(ThrowsSupplier<R> callback, Consumer<BaseException> enhanceCallback) {
        try {
            return callback.get();
        }
        catch (Throwable exception) {
            enhanceCallback.accept(EhSupport.getPropertiesException(exception));
            EhSupport.rethrow(exception);
            throw new IllegalStateException("EhCoreSupport.rethrow must always throw an exception");
        }
    }

    public static <R> R enhanceAndRethrowFn(ThrowsSupplier<R> callback, String name, Object value) {
        return EhSupport.enhanceAndRethrowFn(callback, baseException -> baseException.putProperty(name, value));
    }

    public static Instant getTimeThrown(Throwable exception) {
        return EhSupport.getPropertiesException(exception).getTimeThrown();
    }

    public static void putProperty(Throwable exception, String name, Object value) {
        EhSupport.getPropertiesException(exception).putProperty(name, value);
    }

    public static <E> E tryGetProperty(Throwable exception, String name) {
        return EhSupport.getPropertiesException(exception).tryGetProperty(name);
    }

    public static String tryGetPropertyAsString(Throwable exception, String name) {
        return EhSupport.getPropertiesException(exception).tryGetPropertyAsString(name);
    }

    public static <R> R getExceptionDetails(Throwable exception, Function<StringBuffer, R> callback) {
        return EhSupport.getPropertiesException(exception).getExceptionDetails(callback);
    }

    public static String getExceptionDetailsAsString(Throwable exception) {
        return EhSupport.getPropertiesException(exception).getExceptionDetailsAsString();
    }

    public static void printExceptionDetails(Throwable exception, PrintWriter printWriter) {
        EhSupport.getPropertiesException(exception).printExceptionDetails(printWriter);
    }

    public static void printExceptionDetails(Throwable exception, PrintStream printStream) {
        EhSupport.getPropertiesException(exception).printExceptionDetails(printStream);
    }

    public static <E> E checkResult(Result<E> result) {
        if (!result.isSuccess()) {
            EhSupport.throwEnhanced(result.getException());
        }
        return result.getData();
    }

    static {
        throwHandler = throwable -> EhCoreSupport.rethrowInternal(EhSupport.enhance(throwable));
    }
}

