/*
 * Decompiled with CFR 0.152.
 */
package org.swblocks.jbl.eh;

import java.io.Closeable;
import java.util.function.Consumer;
import org.swblocks.jbl.eh.FatalApplicationError;
import org.swblocks.jbl.functional.ThrowsConsumer;
import org.swblocks.jbl.functional.ThrowsRunnable;
import org.swblocks.jbl.functional.ThrowsSupplier;

class EhCoreSupport {
    public static final Consumer<Throwable> defaultAbortHandler = throwable -> {
        throw new FatalApplicationError("A fatal application error has occurred", (Throwable)throwable);
    };
    protected static Consumer<Throwable> throwHandler = EhCoreSupport::rethrowInternal;
    protected static final Thread.UncaughtExceptionHandler defaultUncaughtHandler;
    protected static Thread.UncaughtExceptionHandler uncaughtHandler;
    private static final Thread.UncaughtExceptionHandler uncaughtHandlerLocalCallback;
    private static Consumer<Throwable> abortHandler;

    protected EhCoreSupport() {
    }

    protected static <T extends Throwable> void rethrowInternal(Throwable throwable) throws T {
        throw throwable;
    }

    public static void rethrow(Throwable throwable) {
        throwHandler.accept(throwable);
    }

    public static void propagate(ThrowsRunnable callback) {
        try {
            callback.run();
        }
        catch (Throwable throwable) {
            EhCoreSupport.rethrow(throwable);
        }
    }

    public static <R> R propagateFn(ThrowsSupplier<R> callback) {
        try {
            return callback.get();
        }
        catch (Throwable throwable) {
            EhCoreSupport.rethrow(throwable);
            throw new IllegalStateException("EhCoreSupport.rethrow must always return or throw an exception");
        }
    }

    public static void fatalOnException(ThrowsRunnable callback) {
        try {
            callback.run();
        }
        catch (Throwable throwable) {
            abortHandler.accept(throwable);
        }
    }

    public static <R> R fatalOnExceptionFn(ThrowsSupplier<R> callback) {
        try {
            return callback.get();
        }
        catch (Throwable throwable) {
            abortHandler.accept(throwable);
            throw new IllegalStateException("EhCoreSupport.fatalOnExceptionFn must always return or throw an exception");
        }
    }

    public static void ensure(boolean expectedCondition, String message, Object ... args) {
        if (!expectedCondition) {
            EhCoreSupport.rethrow(new IllegalStateException(String.format(message, args)));
        }
    }

    public static void ensureArg(boolean expectedCondition, String message, Object ... args) {
        if (!expectedCondition) {
            EhCoreSupport.rethrow(new IllegalArgumentException(String.format(message, args)));
        }
    }

    public static void ensureOrFatal(boolean expectedCondition, String message, Object ... args) {
        if (!expectedCondition) {
            EhCoreSupport.abort(String.format(message, args));
        }
    }

    public static void ensureOrFatal(boolean expectedCondition, Exception cause, String message, Object ... args) {
        if (!expectedCondition) {
            EhCoreSupport.abort(String.format(message, args), cause);
        }
    }

    public static void abort(String message, Exception cause) {
        abortHandler.accept(new IllegalStateException(message, cause));
    }

    public static void abort(String message) {
        abortHandler.accept(new IllegalStateException(message));
    }

    public static Consumer<Throwable> getAbortHandler() {
        return abortHandler;
    }

    public static void setAbortHandler(Consumer<Throwable> abortHandler) {
        EhCoreSupport.abortHandler = abortHandler == null ? defaultAbortHandler : abortHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enhancedFinally(ThrowsRunnable callback, Consumer<Throwable> handler) {
        Throwable savedThrowable = null;
        try {
            callback.run();
            handler.accept(savedThrowable);
        }
        catch (Throwable throwable) {
            try {
                savedThrowable = throwable;
                EhCoreSupport.rethrow(throwable);
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                handler.accept(savedThrowable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R enhancedFinallyFn(ThrowsSupplier<R> callback, Consumer<Throwable> handler) {
        Throwable savedThrowable = null;
        try {
            R r = callback.get();
            return r;
        }
        catch (Throwable throwable) {
            savedThrowable = throwable;
            EhCoreSupport.rethrow(throwable);
        }
        finally {
            handler.accept(savedThrowable);
        }
        throw new IllegalStateException("EhCoreSupport.catchOrFinallyFn must always return or throw an exception");
    }

    public static void trySuppressExceptions(Throwable throwable, ThrowsRunnable callback) {
        try {
            callback.run();
        }
        catch (Throwable suppressed) {
            if (throwable != null) {
                throwable.addSuppressed(suppressed);
            }
            EhCoreSupport.rethrow(suppressed);
        }
    }

    public static void suppressExceptionsOrFatal(Throwable throwable, ThrowsRunnable callback) {
        EhCoreSupport.fatalOnException(() -> EhCoreSupport.trySuppressExceptions(throwable, callback));
    }

    public static <T> void tryCloseQuietly(Throwable throwable, T closeable, ThrowsConsumer<T> closeCallback) {
        EhCoreSupport.trySuppressExceptions(throwable, () -> {
            if (closeable != null) {
                closeCallback.accept(closeable);
            }
        });
    }

    public static void tryCloseQuietly(Throwable throwable, Closeable closeable) {
        EhCoreSupport.tryCloseQuietly(throwable, closeable, Closeable::close);
    }

    public static <T> void closeQuietlyOrFatal(Throwable throwable, T closeable, ThrowsConsumer<T> closeCallback) {
        EhCoreSupport.fatalOnException(() -> EhCoreSupport.tryCloseQuietly(throwable, closeable, closeCallback));
    }

    public static void closeQuietlyOrException(Throwable throwable, Closeable closeable) {
        EhCoreSupport.closeQuietlyOrFatal(throwable, closeable, Closeable::close);
    }

    public static Thread.UncaughtExceptionHandler getDefaultUncaughtHandler() {
        return defaultUncaughtHandler;
    }

    public static Thread.UncaughtExceptionHandler getUncaughtHandler() {
        return uncaughtHandler;
    }

    public static void setUncaughtHandler(Thread.UncaughtExceptionHandler uncaughtHandler) {
        EhCoreSupport.uncaughtHandler = null == uncaughtHandler ? defaultUncaughtHandler : uncaughtHandler;
    }

    static {
        uncaughtHandler = defaultUncaughtHandler = (thread, exception) -> {
            System.err.print("Uncaught exception in thread \"" + thread.getName() + "\" ");
            exception.printStackTrace(System.err);
            Runtime.getRuntime().halt(1);
        };
        uncaughtHandlerLocalCallback = (thread, exception) -> uncaughtHandler.uncaughtException(thread, exception);
        Thread.setDefaultUncaughtExceptionHandler(uncaughtHandlerLocalCallback);
        Thread.currentThread().setUncaughtExceptionHandler(uncaughtHandlerLocalCallback);
        abortHandler = defaultAbortHandler;
    }
}

