/*
 * Decompiled with CFR 0.152.
 */
package org.swblocks.jbl.eh;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.swblocks.jbl.eh.EhCoreProperties;
import org.swblocks.jbl.eh.EhCoreSupport;
import org.swblocks.jbl.eh.EhSupport;

public class BaseException
extends RuntimeException {
    private static final long serialVersionUID = -3761053769452690215L;
    private final Throwable referenceException;
    private final Instant timeThrown;
    private final StackTraceElement callerFrame;
    private final TreeMap<String, Object> properties = new TreeMap();

    protected BaseException(Throwable referenceExceptionToChain, String message, Throwable cause) {
        super(message, cause, true, true);
        this.referenceException = referenceExceptionToChain == null ? this : referenceExceptionToChain;
        this.timeThrown = Instant.now();
        this.callerFrame = this.referenceException.getStackTrace()[0];
        String referenceExceptionMessage = this.referenceException.getMessage();
        if (referenceExceptionMessage != null) {
            this.putProperty("eh:/properties/core/message", this.referenceException.getMessage());
        }
        this.putProperty("eh:/properties/core/time-thrown", this.timeThrown);
        this.putProperty("eh:/properties/core/full-class-name", this.callerFrame.getClassName());
        this.putProperty("eh:/properties/core/method-name", this.callerFrame.getMethodName());
        this.putProperty("eh:/properties/core/line-number", this.callerFrame.getLineNumber());
    }

    public BaseException(String message) {
        this(message, null);
    }

    public BaseException(String message, Throwable cause) {
        this(null, message, cause);
    }

    public Instant getTimeThrown() {
        return this.timeThrown;
    }

    public StackTraceElement getCallerFrame() {
        return this.callerFrame;
    }

    public void putProperty(String name, Object value) {
        EhCoreSupport.ensureOrFatal(name != null && !name.isEmpty(), "The parameter 'name' cannot be null or empty", new Object[0]);
        if (value == null) {
            this.properties.remove(name);
            return;
        }
        EhCoreProperties.validateProperty(name, value);
        Object current = this.properties.get(name);
        if (current == null) {
            this.properties.put(name, value);
        } else if (current instanceof List) {
            List list = (List)current;
            if (list.isEmpty() || !list.get(list.size() - 1).equals(value)) {
                list.add(value);
            }
        } else if (!current.equals(value)) {
            ArrayList<Object> list = new ArrayList<Object>(4);
            list.add(current);
            list.add(value);
            this.properties.put(name, list);
        }
    }

    public <E> E tryGetProperty(String name) {
        E value = this.properties.getOrDefault(name, null);
        if (value != null) {
            if (value instanceof List) {
                List list = (List)value;
                if (list.isEmpty()) {
                    return (E)list;
                }
                return list.get(list.size() - 1);
            }
            return value;
        }
        return null;
    }

    public String tryGetPropertyAsString(String name) {
        Object value = this.tryGetProperty(name);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public <R> R getExceptionDetails(Function<StringBuffer, R> callback) {
        return (R)EhSupport.propagateFn(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    public String getExceptionDetailsAsString() {
        return this.getExceptionDetails(StringBuffer::toString);
    }

    public void printExceptionDetails(PrintWriter printWriter) {
        printWriter.print("Exception was thrown of type '");
        printWriter.print(this.referenceException.getClass().getCanonicalName());
        printWriter.print("'; created at the following location: '");
        printWriter.print(this.callerFrame.getClassName());
        printWriter.print(".");
        printWriter.print(this.callerFrame.getMethodName());
        printWriter.print(":");
        printWriter.print(this.callerFrame.getLineNumber());
        printWriter.println("'");
        printWriter.println("Exception properties:");
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            Consumer<Object> printValue = value -> {
                printWriter.print("[");
                printWriter.print((String)entry.getKey());
                printWriter.print("] ");
                printWriter.println(value);
            };
            Object value2 = entry.getValue();
            if (value2 instanceof List) {
                List list = (List)value2;
                for (int i = list.size() - 1; i >= 0; --i) {
                    printValue.accept(list.get(i));
                }
                continue;
            }
            printValue.accept(value2);
        }
        printWriter.println("Exception stack trace:");
        this.referenceException.printStackTrace(printWriter);
        printWriter.flush();
    }

    public void printExceptionDetails(PrintStream printStream) {
        EhSupport.propagate(() -> {
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)printStream, Charset.forName("UTF-8"));
                 PrintWriter printWriter = new PrintWriter(writer);){
                this.printExceptionDetails(printWriter);
            }
        });
    }
}

