/*
 * Decompiled with CFR 0.152.
 */
package org.swblocks.jbl.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CollectionUtils {
    private static final Map exampleUnmodifiableMap = Collections.unmodifiableMap(Collections.emptyMap());
    private static final List exampleUnmodifiableList = Collections.unmodifiableList(Collections.emptyList());

    private CollectionUtils() {
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    public static <K, V> boolean isNotEmpty(Map<K, V> map) {
        return map != null && !map.isEmpty();
    }

    public static <K, V> Map<K, V> unmodifiableMap(Map<K, V> map) {
        if (CollectionUtils.isNotEmpty(map)) {
            if (!exampleUnmodifiableMap.getClass().equals(map.getClass())) {
                return Collections.unmodifiableMap(map);
            }
            return map;
        }
        return Collections.emptyMap();
    }

    public static <V> List<V> unmodifiableList(List<V> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            if (!exampleUnmodifiableList.getClass().equals(list.getClass())) {
                return Collections.unmodifiableList(list);
            }
            return list;
        }
        return Collections.emptyList();
    }
}

