/*
 * Decompiled with CFR 0.152.
 */
package org.swblocks.jbl.cache;

import java.util.LinkedHashMap;
import java.util.Map;

public final class LruCache<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = -1096634636585306482L;
    private final int maximumEntries;

    private LruCache(int initialCapacity, int maximumEntries, float loadFactor) {
        super(initialCapacity, loadFactor, true);
        this.maximumEntries = maximumEntries;
    }

    public static <K, V> LruCache<K, V> getCache(int initialCapacity, int maximumEntries, float loadFactor) {
        return new LruCache<K, V>(initialCapacity, maximumEntries, loadFactor);
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry eldest) {
        return this.size() > this.maximumEntries;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && this.getClass() == object.getClass() && this.maximumEntries == ((LruCache)object).maximumEntries;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.maximumEntries;
    }
}

