/*
 * Decompiled with CFR 0.152.
 */
package org.swblocks.jbl.builders;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class Builder<B, R> {
    private final Supplier<B> creator;
    private final Function<B, R> buildFn;
    private final Predicate<B> validator;
    private final List<Consumer<B>> instanceModifiers = new ArrayList<Consumer<B>>(1);

    private Builder(Supplier<B> creator, Predicate<B> validator, Function<B, R> buildFn) {
        this.creator = creator;
        this.validator = validator;
        this.buildFn = buildFn;
    }

    public static <B, R> Builder<B, R> instanceOf(Supplier<B> creator, Function<B, R> builder) {
        return new Builder<Object, R>(creator, predicate -> true, builder);
    }

    public static <B, R> Builder<B, R> instanceOf(Supplier<B> creator, Predicate<B> validator, Function<B, R> builder) {
        return new Builder<B, R>(creator, validator, builder);
    }

    public <U> Builder<B, R> with(BiConsumer<B, U> consumer, U value) {
        Consumer<Object> c = instance -> consumer.accept(instance, value);
        this.instanceModifiers.add(c);
        return this;
    }

    public R build() {
        Object objBuilder = this.creator.get();
        this.instanceModifiers.forEach(modifier -> modifier.accept(objBuilder));
        this.instanceModifiers.clear();
        if (this.validator.test(objBuilder)) {
            return this.buildFn.apply(objBuilder);
        }
        return null;
    }
}

