/*
 * Decompiled with CFR 0.152.
 */
package com.technophobia.webdriver.util;

import com.technophobia.substeps.step.StepImplementationUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.htmlunit.HtmlUnitWebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebDriverSubstepsBy {
    public static ByIdAndText ByIdAndText(String id, String text) {
        return new ByIdAndText(id, text);
    }

    public static ByIdAndText ByIdAndCaseSensitiveText(String id, String text) {
        return new ByIdAndText(id, text, true);
    }

    public static ByTagAndAttributes ByTagAndAttributes(String tagName, Map<String, String> requiredAttributes) {
        return new ByTagAndAttributes(tagName, requiredAttributes);
    }

    public static ByTagAndAttributes ByTagAndAttributes(String tagName, String attributeString) {
        Map expectedAttributes = StepImplementationUtils.convertToMap((String)attributeString);
        return new ByTagAndAttributes(tagName, expectedAttributes);
    }

    public static ByTagAndAttributes NthByTagAndAttributes(String tagName, String attributeString, int nth) {
        Map expectedAttributes = StepImplementationUtils.convertToMap((String)attributeString);
        return new ByTagAndAttributes(tagName, expectedAttributes, nth);
    }

    public static ByCurrentWebElement ByCurrentWebElement(WebElement elem) {
        return new ByCurrentWebElement(elem);
    }

    public static ByTagAndWithText ByTagAndWithText(String tag, String text) {
        return new ByTagAndWithText(tag, text);
    }

    public static ByTagAndWithText ByTagContainingText(String tag, String text) {
        return new ByTagAndContainingText(tag, text);
    }

    public static ByTagAndWithText ByTagStartingWithText(String tag, String text) {
        return new ByTagAndStartingWithText(tag, text);
    }

    public static ByIdContainingText ByIdContainingText(String id, String text) {
        return new ByIdContainingText(id, text);
    }

    public static BySomethingContainingText ByXpathContainingText(String xpath, String text) {
        return new BySomethingContainingText(By.xpath((String)xpath), text);
    }

    private static String equalsIgnoringCaseXPath(String str1, String str2) {
        return "translate(" + str1 + ", 'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz')=" + str2;
    }

    public static ByTagAndAttributesWithValue ByTagAndAttributesWithValue(String tagName, String attributeString, String value) {
        Map expectedAttributes = StepImplementationUtils.convertToMap((String)attributeString);
        return new ByTagAndAttributesWithValue(tagName, (Map<String, String>)expectedAttributes, value);
    }

    public static ByTagAndAttributesWithText ByTagAndAttributesWithText(String tagName, String attributeString, String text) {
        Map expectedAttributes = StepImplementationUtils.convertToMap((String)attributeString);
        return new ByTagAndAttributesWithText(tagName, expectedAttributes, text);
    }

    static class ByTagAndAttributesWithValue
    extends ByTagAndAttributes {
        private final String value;

        ByTagAndAttributesWithValue(String tagName, Map<String, String> requiredAttributes, String value) {
            super(tagName, requiredAttributes);
            this.value = value;
        }

        ByTagAndAttributesWithValue(String tagName, Map<String, String> requiredAttributes, String value, int nth) {
            super(tagName, requiredAttributes, nth);
            this.value = value;
        }

        @Override
        public List<WebElement> findElementsBy(SearchContext searchContext) {
            List<WebElement> initialMatchingElems = super.findElementsBy(searchContext);
            ArrayList<WebElement> matchingElems = null;
            if (initialMatchingElems != null) {
                for (WebElement e : initialMatchingElems) {
                    String val = e.getAttribute("value");
                    if (val == null || val.compareTo(this.value) != 0) continue;
                    if (matchingElems == null) {
                        matchingElems = new ArrayList<WebElement>();
                    }
                    matchingElems.add(e);
                }
            }
            return matchingElems;
        }
    }

    static class ByTagAndAttributesWithText
    extends XPathBy {
        private static final Logger logger = LoggerFactory.getLogger(ByTagAndAttributesWithText.class);
        private final String tagName;
        private final Map<String, String> requiredAttributes;
        private final String text;
        private final int minimumExpected;

        ByTagAndAttributesWithText(String tagName, Map<String, String> requiredAttributes, String text) {
            this(tagName, requiredAttributes, text, 1);
        }

        ByTagAndAttributesWithText(String tagName, Map<String, String> requiredAttributes, String text, int nth) {
            this.tagName = tagName;
            this.requiredAttributes = requiredAttributes;
            this.text = text;
            this.minimumExpected = nth;
        }

        @Override
        protected void buildXPath(StringBuilder xpathBuilder) {
            xpathBuilder.append(".//").append(this.tagName);
            boolean hasAttributes = !this.requiredAttributes.isEmpty();
            boolean hasText = StringUtils.isNotEmpty((CharSequence)this.text);
            if (hasAttributes || hasText) {
                xpathBuilder.append("[");
                boolean firstOne = true;
                for (Map.Entry<String, String> requiredAttribute : this.requiredAttributes.entrySet()) {
                    if (!firstOne) {
                        xpathBuilder.append(" and ");
                    }
                    xpathBuilder.append("@").append(requiredAttribute.getKey()).append(" = '").append(requiredAttribute.getValue()).append("'");
                    firstOne = false;
                }
                if (hasText) {
                    if (!firstOne) {
                        xpathBuilder.append(" and ");
                    }
                    xpathBuilder.append("text()='").append(this.text).append("'");
                }
                xpathBuilder.append("]");
            }
            logger.debug("returning by xpath string: " + xpathBuilder.toString());
        }

        @Override
        public List<WebElement> findElementsBy(SearchContext searchContext) {
            List<WebElement> matchingElems = super.findElementsBy(searchContext);
            if (matchingElems != null && matchingElems.size() < this.minimumExpected) {
                logger.info("expecting at least " + this.minimumExpected + " matching elems, found only " + matchingElems.size() + " this time around");
                return null;
            }
            return matchingElems;
        }
    }

    public static class ByIdAndText
    extends XPathBy {
        protected final String text;
        protected final String id;
        protected final boolean caseSensitive;

        ByIdAndText(String id, String text) {
            this(id, text, false);
        }

        ByIdAndText(String id, String text, boolean caseSensitive) {
            this.id = id;
            this.text = text;
            this.caseSensitive = caseSensitive;
        }

        @Override
        protected void buildXPath(StringBuilder xpathBuilder) {
            xpathBuilder.append(".//*[@id='").append(this.id).append("' and ");
            if (this.caseSensitive) {
                xpathBuilder.append("text()='").append(this.text).append("'");
            } else {
                xpathBuilder.append(WebDriverSubstepsBy.equalsIgnoringCaseXPath("text()", "'" + this.text.toLowerCase() + "'"));
            }
            xpathBuilder.append("]");
        }
    }

    static class ByIdContainingText
    extends XPathBy {
        protected final String text;
        protected final String id;

        ByIdContainingText(String id, String text) {
            this.id = id;
            this.text = text;
        }

        @Override
        protected void buildXPath(StringBuilder xpathBuilder) {
            xpathBuilder.append(".//*[@id='").append(this.id).append("' and contains(text(), '").append(this.text).append("')]");
        }
    }

    static class BySomethingContainingText
    extends BaseBy {
        protected final String text;
        protected final By by;

        BySomethingContainingText(By by, String text) {
            this.by = by;
            this.text = text;
        }

        @Override
        public List<WebElement> findElementsBy(SearchContext context) {
            ArrayList<WebElement> matchingElems = null;
            List elems = context.findElements(this.by);
            if (elems != null) {
                for (WebElement e : elems) {
                    if (e.getText() == null || !e.getText().contains(this.text)) continue;
                    if (matchingElems == null) {
                        matchingElems = new ArrayList<WebElement>();
                    }
                    matchingElems.add(e);
                }
            }
            return matchingElems;
        }
    }

    static class ByTagAndStartingWithText
    extends ByTagAndWithText {
        ByTagAndStartingWithText(String tag, String text) {
            super(tag, text);
        }

        @Override
        protected void buildXPath(StringBuilder xpathBuilder) {
            xpathBuilder.append(".//").append(this.tag).append("[starts-with(text(), '").append(this.text).append("')]");
        }
    }

    static class ByTagAndContainingText
    extends ByTagAndWithText {
        ByTagAndContainingText(String tag, String text) {
            super(tag, text);
        }

        @Override
        protected void buildXPath(StringBuilder xpathBuilder) {
            xpathBuilder.append(".//").append(this.tag).append("[contains(text(), '").append(this.text).append("')]");
        }
    }

    static class ByTagAndWithText
    extends XPathBy {
        protected final String tag;
        protected final String text;

        ByTagAndWithText(String tag, String text) {
            this.tag = tag;
            this.text = text;
        }

        @Override
        protected void buildXPath(StringBuilder xpathBuilder) {
            xpathBuilder.append(".//").append(this.tag).append("[").append(WebDriverSubstepsBy.equalsIgnoringCaseXPath("text()", "'" + this.text.toLowerCase() + "'")).append("]");
        }
    }

    static class ByCurrentWebElement
    extends BaseBy {
        private final WebElement currentElement;

        public ByCurrentWebElement(WebElement elem) {
            this.currentElement = elem;
        }

        @Override
        public List<WebElement> findElementsBy(SearchContext context) {
            ArrayList<WebElement> matchingElems = new ArrayList<WebElement>();
            matchingElems.add(this.currentElement);
            return matchingElems;
        }
    }

    static class ByTagAndAttributes
    extends XPathBy {
        private static final Logger logger = LoggerFactory.getLogger(ByTagAndAttributes.class);
        private final String tagName;
        private final Map<String, String> requiredAttributes;
        private final int minimumExpected;

        ByTagAndAttributes(String tagName, Map<String, String> requiredAttributes) {
            this.tagName = tagName;
            this.requiredAttributes = requiredAttributes;
            this.minimumExpected = 1;
        }

        ByTagAndAttributes(String tagName, Map<String, String> requiredAttributes, int nth) {
            this.tagName = tagName;
            this.requiredAttributes = requiredAttributes;
            this.minimumExpected = nth;
        }

        @Override
        protected void buildXPath(StringBuilder xpathBuilder) {
            xpathBuilder.append(".//").append(this.tagName);
            if (!this.requiredAttributes.isEmpty()) {
                xpathBuilder.append("[");
                boolean firstOne = true;
                for (Map.Entry<String, String> requiredAttribute : this.requiredAttributes.entrySet()) {
                    if (!firstOne) {
                        xpathBuilder.append(" and ");
                    }
                    xpathBuilder.append("@").append(requiredAttribute.getKey()).append(" = '").append(requiredAttribute.getValue()).append("'");
                    firstOne = false;
                }
                xpathBuilder.append("]");
            }
        }

        @Override
        public List<WebElement> findElementsBy(SearchContext searchContext) {
            List<WebElement> matchingElems = super.findElementsBy(searchContext);
            if (matchingElems != null && matchingElems.size() < this.minimumExpected) {
                logger.info("expecting at least " + this.minimumExpected + " matching elems, found only " + matchingElems.size() + " this time around");
                return null;
            }
            return matchingElems;
        }
    }

    public static abstract class XPathBy
    extends BaseBy {
        @Override
        public List<WebElement> findElementsBy(SearchContext context) {
            StringBuilder xpathBuilder = new StringBuilder();
            this.buildXPath(xpathBuilder);
            return context.findElements(By.xpath((String)xpathBuilder.toString()));
        }

        protected abstract void buildXPath(StringBuilder var1);
    }

    public static abstract class BaseBy
    extends By {
        private static Logger logger = LoggerFactory.getLogger(BaseBy.class);

        public final List<WebElement> findElements(SearchContext context) {
            List matchingElems = null;
            try {
                matchingElems = this.findElementsBy(context);
            }
            catch (StaleElementReferenceException e) {
                logger.debug("StaleElementReferenceException looking for elements");
            }
            if (matchingElems == null && context instanceof HtmlUnitWebElement) {
                matchingElems = Collections.EMPTY_LIST;
            }
            return matchingElems;
        }

        public abstract List<WebElement> findElementsBy(SearchContext var1);
    }
}

